/**
 * Copyright GreekFellows ( http://wonderfl.net/user/GreekFellows )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dfOk
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class SpinClock extends Sprite {
        public var board:Sprite;
        public var numbers:Array;
        public var hour:Sprite;
        public var minute:Sprite;
        public var second:Sprite;
        
        // 0 - drawing board
        // 1 - drawing numbers
        // 2 - drawing three pointers
        public var procedure:int = 0;
        
        // angle count for drawing board
        public var boardangle:int = 0;
        
        // length count for drawing numbers
        public var numberslength:int = 0;
        
        // length count for three pointers
        public var pointerslength:Number = 0;
        
        public var date:Date;
        
        public function SpinClock() {
            this.x = 465 / 2;
            this.y = 465 / 2;
            stage.frameRate = 120;
            
            init();
        }
        
        public function init():void {
            board = new Sprite();
            numbers = [];
            
            this.addChild(board);
            
            date = new Date();
            
            this.addEventListener(Event.ENTER_FRAME, spinclock);
        }
        
        public function spinclock(e:Event):void {
            switch (procedure) {
                case 0:
                if (boardangle < 360) {
                    if (boardangle == 0) board.graphics.moveTo(Math.cos((boardangle - 3) * Math.PI / 180) * 100, Math.sin((boardangle - 3) * Math.PI / 180) * 100);
                    boardangle += 3;
                    board.graphics.lineStyle(5, 0, 1);
                    board.graphics.lineTo(Math.cos(boardangle * Math.PI / 180) * 100, Math.sin(boardangle * Math.PI / 180) * 100);
                } else {
                    board.graphics.clear();
                    board.graphics.lineStyle(5, 0, 1);
                    board.graphics.drawCircle(0, 0, 100);
                    
                    procedure = 1;
                }
                break;
                
                case 1:
                if (numbers.length == 0) {
                    for (var psi:int = 0; psi < 12; psi++) {
                        numbers.push(new Sprite());
                        numbers[psi].rotation = psi * 360 / 12;
                        this.addChild(numbers[psi]);
                    }
                } else {
                    if (numberslength < 15) {
                        numberslength += 1;
                        for (var dsi:int = 0; dsi < numbers.length; dsi++) {
                            numbers[dsi].graphics.lineStyle(5, 0, 1);
                            numbers[dsi].graphics.moveTo(0, -85 + numberslength - 1);
                            numbers[dsi].graphics.lineTo(0, -85 + numberslength);
                        }
                    } else {
                        procedure = 2;
                    }
                }
                break;
                
                case 2:
                if (hour == null) {
                    hour = new Sprite();
                    minute = new Sprite();
                    second = new Sprite();
                    
                    hour.rotation = date.getHours() * 360 / 12;
                    minute.rotation = date.getMinutes() * 360 / 60;
                    second.rotation = date.getSeconds() * 360 / 60;
                    
                    this.addChild(hour);
                    this.addChild(minute);
                    this.addChild(second);
                } else {
                    if (pointerslength < 20) {
                        pointerslength += 1;
                        
                        hour.graphics.lineStyle(5, 0, 1);
                        hour.graphics.moveTo(0, -35 + pointerslength / 20 * 35 - (pointerslength - 1) / 20 * 35);
                        hour.graphics.lineTo(0, -35 + pointerslength / 20 * 35);
                        
                        minute.graphics.lineStyle(5, 0, 1);
                        minute.graphics.moveTo(0, -45 + pointerslength / 20 * 45 - (pointerslength - 1) / 20 * 45);
                        minute.graphics.lineTo(0, -45 + pointerslength / 20 * 45);
                        
                        second.graphics.lineStyle(5, 0, 1);
                        second.graphics.moveTo(0, -55 + pointerslength / 20 * 55 - (pointerslength - 1) / 20 * 55);
                        second.graphics.lineTo(0, -55 + pointerslength / 20 * 55);
                    } else {
                        procedure = 3;
                    }
                }
                break;
                
                case 3:
                date = new Date();
                hour.rotation = date.getHours() * 360 / 12;
                minute.rotation = date.getMinutes() * 360 / 60;
                second.rotation = date.getSeconds() * 360 / 60;
                break;
            }
        }
    }
}