/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dckW
 */

package
{
	import flash.display.Sprite
	import flash.events.Event;
	
	public class Main extends Sprite
	{	
		private var data:Array;
		
		public function Main()
		{
			var c1:Circle = addChild(new Circle(100, 300)) as Circle;
			var c2:Circle = addChild(new Circle(200, 100)) as Circle;
			var c3:Circle = addChild(new Circle(300, 400)) as Circle;
			
			data = [c1, c2, c3];
			
			c1.addEventListener(Event.CHANGE, onChange);
			c2.addEventListener(Event.CHANGE, onChange);
			c3.addEventListener(Event.CHANGE, onChange);
			
			onChange();
		}
		
		private function onChange(event:Event = null):void
		{
			graphics.clear();
			graphics.lineStyle(2.0, 0x0, 0.1);
			graphics.moveTo(data[0].x, data[0].y);
			graphics.lineTo(data[1].x, data[1].y);
			graphics.lineTo(data[2].x, data[2].y);
			
			graphics.lineStyle(2.0);
			graphics.moveTo(data[0].x, data[0].y);
			graphics.curveTo(data[1].x, data[1].y, data[2].x, data[2].y);
		}
	}
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;

class Circle extends Sprite
{
	public function Circle(x:Number, y:Number)
	{
		this.x = x;
		this.y = y;
		
		graphics.lineStyle(2.0, 0x0);
		graphics.beginFill(0xFFFFFF);
		graphics.drawCircle(0, 0, 5);
		graphics.endFill();
		
		addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
		addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
	}
	
	private function onMouseUp(event:MouseEvent):void 
	{
		stopDrag();
		removeEventListener(Event.ENTER_FRAME, onEnterFrame);
	}
	
	private function onMouseDown(event:MouseEvent):void 
	{
		startDrag();
		addEventListener(Event.ENTER_FRAME, onEnterFrame);
	}
	
	private function onEnterFrame(event:Event):void 
	{
		dispatchEvent(new Event(Event.CHANGE));
	}
}