/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dcd8
 */

package 
{
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.navigateToURL;
    import flash.net.URLRequest;
    import flash.system.Capabilities;
    import flash.system.LoaderContext;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import net.wonderfl.widget.Wanco;
    import com.bit101.components.*;
    
    public class Main extends Sprite 
    {
        private static const CURRENT_FP_VERSION:String = "11.4";
        
        public function Main():void 
        {
            var tf:TextField = new TextField();
            tf.defaultTextFormat = new TextFormat("Arial", 16, null, true, null, null, null, null, "center");
            tf.autoSize = TextFieldAutoSize.CENTER;
            addChild(tf);
            
            if (VersionUtil.isRuntimeRequired(CURRENT_FP_VERSION))
            {
                tf.text = "Your Version is [" + Capabilities.version + "]\nGood!";
                
                var loader:Loader = new Loader();
                loader.load(new URLRequest('http://www.project-nya.jp/images/flash/chick.swf'), new LoaderContext(true));
                addChild(loader);
                
                loader.x = stage.stageWidth / 2 >> 0;
                loader.y = stage.stageHeight / 2 >> 0;
            }
            else
            {
                tf.text = "Your Version is [" + Capabilities.version + "]\nPlease Get Flash Player " + CURRENT_FP_VERSION;
                new PushButton( this, stage.stageWidth / 2 - 60, stage.stageHeight/2 + 100, "Get Flash Player " + CURRENT_FP_VERSION, function(e:*):void {
                    navigateToURL(new URLRequest("http://get.adobe.com/flashplayer/"), "_blank");
                });
                
                
                var wanco:Wanco = new Wanco();
                addChild(wanco);
                
                wanco.x = stage.stageWidth / 2 >> 0;
                wanco.y = stage.stageHeight / 2 >> 0;
            }
            
            tf.x = (stage.stageWidth - tf.textWidth) / 2 >> 0;
            tf.y = stage.stageHeight / 2 + 50 >> 0;
        }
    }
}


import flash.system.Capabilities;

/**
* バージョンチェックのためのユーティリティクラスです。
* @author clockmaker
* @since 2011/02/14
* @version 1.0.0
* @see http://utils.libspark.org/
* @see http://www.libspark.org/
*/
class VersionUtil
{
    private static const SPECIALS:Array = ["alpha", "beta", "rc", "rtm"];
    
    /**
     * ランタイムが要求するバージョンを満たしているかチェックします。
     * @param 要求するバージョン番号. 例：9.0.115
     * @return 満たしている場合は true
     * @author clockmaker
     * @since 2011/02/14
     */
    public static function isRuntimeRequired(targetVersion:String):Boolean
    {
        return compareVersion(getRuntimeVersion(), targetVersion, true);
    }
    
    /**
     * 新しいバージョンかどうかを比較します。
     * バージョンの区切り文字は「.」(ドット)のみです。
     * @param targetVersion 基準となるバージョン
     * @param compareVersion 比較対象のバージョン
     * @param includeEqual 条件を「以上」にしたいならtrue。「より大きい」にしたいならfalse。デフォルト値はtrue。
     * @return targetVersion が compareVersion と比較して大なら true
     * @author  clockmaker
     * @since 2011/02/14
     *
     * バージョンチェックのアルゴリズム
     *   1. +,-,_,SPACE,COMMAはドットとして変換 : 1.2+-__5 => 1.2...5
     *   2. 連続したドットは単独のドットとして変換  1.2...5 => 1.2.5
     *   3. 数字と文字・記号の間にはドットを挿入: 1beta1 => 1.beta.1
     *   4. ドットを区切り文字として扱う
     *   5. 数字は大小で比較を行う, 文字列の中でもalpha,beta,rcは特別な意味ものとして扱う。大小関係はalpha < beta < rcと < rtm とする。 
     */
    public static function compareVersion(targetVersion:String, compareVersion:String, includeEqual:Boolean = true):Boolean
    {
        var v1:String = compareVersion.replace(/[+\-_, ]/g, ".").replace(/\.(\.)+/g, ".").replace(/([^\d\.])([^\D\.])/g, "$1.$2").replace(/([^\D\.])([^\d\.])/g, "$1.$2");
        var v2:String = targetVersion.replace(/[+\-_, ]/g, ".").replace(/\.(\.)+/g, ".").replace(/([^\d\.])([^\D\.])/g, "$1.$2").replace(/([^\D\.])([^\d\.])/g, "$1.$2");
    
        var parts1:Array = v1.split(".");
        var parts2:Array = v2.split(".");
        
        var minLen:int = Math.min(parts1.length, parts2.length);
        
        for (var i:int = 0; i < minLen; i ++)
        {
            var p1:String = parts1[i];
            var p2:String = parts2[i];
            
            var isDigit1:Boolean = isDigit(p1.charAt(0));
            var isDigit2:Boolean = isDigit(p2.charAt(0));
            // 数字の比較
            if (isDigit1 && isDigit2)
            {
                var n1:uint = uint(p1);
                var n2:uint = uint(p2);
                if (n2 != n1) return n2 > n1;

            }
            // アルファニューメリックの比較      
            else if (!isDigit1 && !isDigit2) 
            {
                var index1:int = SPECIALS.indexOf(p1.toLowerCase());
                var index2:int = SPECIALS.indexOf(p2.toLowerCase());
                // rtm > rc > beta > alpha
                if (index1 != -1 && index2 != -1)
                {
                    if (index1 != index2) return index2 > index1; 
                } else 
                {
                    var p1l:String = p1.toLowerCase();
                    var p2l:String = p2.toLowerCase();
                    if (p2l != p1l) return p2l > p1l;
                }
            } 
            // 数字とアルファニューメリックの比較
            else
            {
                // 数字 > アルファニューメリック
                if (isDigit1)
                    return false;
                return true;
            }
        }
        if (parts1.length == parts2.length)
        {
            return includeEqual;
        }
        
        if (parts1.length > parts2.length)
        {
            // 数字のほうが大きい
            if (isDigit(parts1[minLen].charAt(0)))
            {
                return false;
            } else {
                // アルファニューメリックのほうが小さい
                return true;
            } 
        }
        // バージョン番号に他のパーツがあった場合は、数字のほうが大きいとして扱う
        if (isDigit(parts2[minLen].charAt(0)))
        {
            return true;
        }
        // アルファニューメリックのほうが小さい
        return false;
    }
    
    /**
     * クライアントのFlash Playerのバージョンを取得します。
     * @param separator 区切り文字。デフォルトは","(カンマ).
     * @return Flash Player のバージョン。
     * @author  clockmaker
     * @since 2011/02/14
     */
    public static function getRuntimeVersion(separator:String = ","):String
    {
        return Capabilities.version.split(" ")[1].split(",").join(separator);
    }
    
    /**
     * @private
     * @author  clockmaker
     * @since 2011/02/14
     */
    private static function isDigit(ch:String):Boolean
    {
        return ch >= '0' && ch <= '9';
    }
}
