/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dbWD
 */

package  
{
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import com.actionsnippet.qbox.QuickBox2D;
    import com.actionsnippet.qbox.QuickObject;
    import flash.display.Graphics;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import frocessing.color.ColorHSV;

    public class RingAloner extends MovieClip 
    {
        private var sim:QuickBox2D;
        private var segmentWidth:Number;
        private var segmentHeight:Number;
        private var ìsStartingAtX:Boolean=false;
        
        public function RingAloner() 
        {
            sim = new QuickBox2D(this, { debug:false } );
            sim.gravity = new b2Vec2(0,10);
            sim.createStageWalls();
            var sh:Number = stage.stageHeight / 30;
            var wallWidthHalves:Number = 0.5;
            segmentWidth = 0.5;
            var ringRadius:Number = 3;
            var floorPosition:Number = sh - ringRadius - 0.5 * segmentWidth - wallWidthHalves;
            var stageWidthHalves:Number = 0.5 * stage.stageWidth / 30;
            addRing(stageWidthHalves, floorPosition, ringRadius);
            // start simulation
            sim.start();
            sim.mouseDrag();            
        }
        
        private function addRing(cx:Number, cy:Number,r:Number):void 
        {
            var color:ColorHSV = new ColorHSV();
            var extraWidthFactor:Number = 1.2;
            var segmentAmount:Number = 20;
            var deltaAngle:Number = Math.PI * 2 / segmentAmount;
            segmentHeight = 2 * r * Math.sin(deltaAngle * 0.5)*extraWidthFactor;
            var angle:Number = 0;
            color.h = angle;
            var box:Object = 
            { 
                width:segmentWidth, 
                height:segmentHeight, 
                fixedRotation:false,
                angularDamping:1, 
                density:1,
                fillAlpha:0
            };
            setBoxPosition(box, cx, cy, r, angle);
            //box["groupIndex"] = -1;
            var pre:QuickObject = sim.addBox( box );
            doMarkBox(pre,angle);
            //box["groupIndex"] = 1;
            var first:QuickObject = pre;
            for (var i:int = 0; i <segmentAmount-1; i++) 
            {
                angle += deltaAngle;
                color.h = angle
                setBoxPosition(box, cx, cy, r, angle);
                //if (i == segmentAmount - 2)
                //{
                    //box["groupIndex"] = -1;
                    //box["fillAlpha"] = 0.5;
                //}
                var curr:QuickObject = sim.addBox(box);
                doMarkBox(curr,angle);
                addJoint( pre.body, curr.body );
                pre = curr;
            }
            curr = first;
            addJoint(pre.body,curr.body,-pre.body.GetAngle()+curr.body.GetAngle());
        }
        
        private function doMarkBox(box:QuickObject, angle:Number):void 
        {
            var g:Graphics = Sprite(box.body.m_userData).graphics;
            g.beginFill(new ColorHSV(angle*180/Math.PI).value);
            g.drawRect( -2, -2, 4, 4);
            g.endFill();
        }
        
        
        private function addJoint(aArg:b2Body, bArg:b2Body,referenceAngleArg:Number=0):void 
        {
            var radius:Number = 1;
            var getAngle:Number = aArg.GetAngle()+Math.PI*0.5;
            var output:QuickObject = sim.addJoint( { a:aArg, b:bArg, type:QuickBox2D.REVOLUTE 
            ,lowerAngle: -2, upperAngle:2, enableLimit:true, referenceAngle:referenceAngleArg,
            vecA:new b2Vec2(
                aArg.GetPosition().x + segmentHeight * 0.5 * Math.cos(getAngle), 
                aArg.GetPosition().y + segmentHeight * 0.5 * Math.sin(getAngle)
                ),
                collideConnected:false
            } );
        }
        
         private function setBoxPosition(box:Object,cx:Number,cy:Number,r:Number,angle:Number):void 
        {
            if (ìsStartingAtX) 
            {
                box["angle"] = angle;
                box["x"] = cx + r * Math.cos(angle);
                box["y"] = cy + r * Math.sin(angle);
            }
            else
            {
                box["angle"] = angle+Math.PI*0.5;
                box["x"] = cx - r * Math.sin(angle);
                box["y"] = cy + r * Math.cos(angle);
            }
        }
        
       
        
    }

}


