/**
 * Copyright fladdict ( http://wonderfl.net/user/fladdict )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dbTo
 */

package {
    import flash.events.*;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        public var dot:MovieClip;
        public var line:MovieClip;
        
        public var offsetX:Number;
        public var rot:Number = 0;
        public var rotV:Number = 0;
        public var fx:Number = 0;
        
        public function FlashTest() {
            // write as3 code here..
            offsetX = this.stage.stageWidth * 0.5;
            rot = 45;
            rotV = 0;
            
            line = new MovieClip();
            line.graphics.lineStyle(0,0x000000,1,false,"normal");
            line.graphics.moveTo(0,0);
            line.graphics.lineTo(100,100);
            this.addChild(line);
            
            dot = new MovieClip();
            dot.graphics.beginFill(0x000000,1);
            dot.graphics.drawCircle(0,0,10);
            dot.graphics.endFill();
            dot.x = offsetX;
            dot.y = 240;
            this.addChild(dot);
                        
            this.addEventListener(Event.EXIT_FRAME, enterframeHandler, false, 0, true);
            this.stage.addEventListener(MouseEvent.MOUSE_DOWN, mousedownHandler, false, 0, true);
        }
        
        public function enterframeHandler(e:Event):void{
            var rotA:Number = 0;
            
            
            //Gravity
            var gfx:Number = Math.cos(rot*Math.PI/180)*0.4; 
            var gfy:Number = Math.sin(rot*Math.PI/180)*0.4;
            
            fx *= 0.9;
            
            var ffx:Number = Math.sin(rot*Math.PI/180)*fx;
            rotA += ffx;
            rotA += gfx;
            
            rotV = rotV * 0.99 + rotA;
            rot += rotV;
            
            var dotX:Number = offsetX + Math.cos(rot*Math.PI/180.0) * 240; 
            var dotY:Number = Math.sin(rot*Math.PI/180.0) * 240;
            dot.x = dotX;
            dot.y = dotY;
            
            this.updateView();
        }

        public function updateView():void{
            var lw:Number = (dot.x-line.x);
            lw = (lw==0)? 0.1 : lw;
            var lh:Number = (dot.y-line.y);
            lh = (lh==0)? 0.1 : lh;
            
            line.x = offsetX;
            line.scaleX = lw/100;
            line.scaleY = lh/100;
        }

        public function mousedownHandler(e:MouseEvent):void{
            fx = -1;
        }

    }
}