/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dayd
 */

// forked from mousepancyo's Game of Life with PV3D
// forked from mousepancyo's Game of Life Color with Glider Gun
/*--- New ---

『ライフゲーム』今度はPV3Dのキューブに貼り付けてみました。
特に意味はないのですが何となくキレイかなぁと思って…
*/

/*--- Second Virsion ---

『ライフゲーム』のセルに色を付けたバージョンです。
色の意味は下記の通り。

オレンジ：誕生して次の世代も生き延びるセル
イエロー：2世代生きたセル
ブルー：3世代生きたセル
グリーン：4世代以上生き続けているセル
レッド：次の世代で死ぬことが決まっているセル

同時に【ゴスパーのグライダー銃】のデモも実装しました。
GLIDER GUN DEMO ボタンを押すと永久持続パターンである
GliderGunが始まります。
*/

package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.geom.Matrix;
    import flash.utils.Timer;
    import com.bit101.components.*;
    import net.hires.debug.Stats;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.materials.utils.MaterialsList;

    [SWF(width="465", height="465", backgroundColor="0xFCFCFC", frameRate="30")]

    public class Main extends Sprite {
        
        private var _w:int = stage.stageWidth;
        private var _h:int = stage.stageHeight;
        private var _gridList:Vector.<Rect> = new Vector.<Rect>();
        private var _rectList:Vector.<Rect> = new Vector.<Rect>();
        private var _xNum:int = 45
        private var _yNum:int = 45
        private var _timer:Timer;
        private var _interval:int;
        private var _isGame:Boolean;
        
        private var _startBtn:PushButton
        private var _pauseBtn:PushButton
        private var _griderGunBtn:PushButton
        private var _kaleidoscopeBtn:PushButton
        private var _label:Label
        private var _radioBtn1:RadioButton;
        private var _radioBtn2:RadioButton;
        private var _radioBtn3:RadioButton;
        private var _radioBtn4:RadioButton;

        private var _griderGunList:Vector.<int> = Vector.<int>([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
        
        private var _kaleidoscopeList:Vector.<int> = Vector.<int>([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
        
        //
        private var _scene:Scene3D;
        private var _camera:Camera3D;
        private var _viewport:Viewport3D;
        private var _renderer:BasicRenderEngine;
        private var _cube:Cube

        private var _vpX:Number;
        private var _vpY:Number;
        
        private var _isDragging:Boolean
        private var _currentMouseX:Number = 0
        private var _currentMouseY:Number = 0

        private var _container:Sprite = new Sprite()
        private var _bmd:BitmapData = new BitmapData(450, 450, false, 0x000A1E)
        
        public function Main () {
            var colors:Array = [0x003C78, 0x000A1E, 0x001E3C]
            var alphas:Array = [1, 1, 1]
            var ratios:Array = [20, 127, 235]
            var mat:Matrix = new Matrix()
            mat.rotate(Math.PI / 180 * 30);
            _container.graphics.beginGradientFill("linear", colors, alphas, ratios, mat)
            _container.graphics.drawRect(0,0,450,450)
            _container.graphics.endFill()
            //
            _container.x = 7
            _container.y = 7
            //
            init3D();
            addChild(_container)
            //
            _startBtn = new PushButton(this, 180, 415, "LIFE GAME START", statLifeGame);
            _griderGunBtn = new PushButton(this, 130, 440, "GLIDER GUN DEMO", statLifeGame);
            _kaleidoscopeBtn = new PushButton(this, 235, 440, "KALEIDSCOPE DEMO", statLifeGame);
            makeGrid(_xNum, _yNum, 0, 0);
            //
            _interval = 100;
        }
        
        private function makeGrid(xNum:int, yNum:int, xOffset:int, yOffset:int):void{
            for(var i:int=0; i<yNum; i++){
                for(var j:int=0; j<xNum; j++){
                    var grid:Rect = new Rect(true, false)
                    _container.addChild(grid)
                    grid.x = grid.width * j + xOffset
                    grid.y = grid.height * i + yOffset
                    grid.id = j + i * xNum
                    _gridList.push(grid)
                    grid.addEventListener(MouseEvent.MOUSE_OVER, rectVisibleChange)
                    grid.addEventListener(MouseEvent.CLICK, rectVisibleChange)
                }
            }
            for(i=0; i<yNum; i++){
                for(j=0; j<xNum; j++){
                    var rect:Rect = new Rect(false, true)
                    _container.addChild(rect)
                    rect.x = rect.width * j + xOffset
                    rect.y = rect.height * i + yOffset
                    rect.id = j + i * xNum
                    rect.mouseEnabled = false
                    rect.visible = false
                    _rectList.push(rect)
                }
            }
        }
        
        private function rectVisibleChange(e:MouseEvent):void{
            if(e.type == "click"){
                if(_rectList[e.target.id].visible == false){
                    _rectList[e.target.id].visible = _rectList[e.target.id].nextLiveFlg = true
                }else{
                    _rectList[e.target.id].visible = _rectList[e.target.id].nextLiveFlg = false
                }
                return
            }
            if(e.buttonDown == true){
                if(_rectList[e.target.id].visible == false){
                    _rectList[e.target.id].visible = _rectList[e.target.id].nextLiveFlg = true
                }else{
                    _rectList[e.target.id].visible = _rectList[e.target.id].nextLiveFlg = false
                }
            }
        }
        
        private function statLifeGame(e:MouseEvent):void{
            _cube.visible = true
            _container.visible = false
            for(var i:int=0; i<_xNum * _yNum; i++){
                _gridList[i].visible = false
            }
            //
            if(e.currentTarget == _griderGunBtn){
                if(_timer != null){
                    _timer.stop()
                    _timer.removeEventListener(TimerEvent.TIMER, update)
                    _timer = null
                }
                for(i=0; i<_xNum * _yNum; i++){
                    _rectList[i].visible = _rectList[i].nextLiveFlg = false
                    if(_griderGunList[i] == 1){
                        _rectList[i].visible = _rectList[i].nextLiveFlg = true
                    }
                }
            }
            //
            if(e.currentTarget == _kaleidoscopeBtn){
                if(_timer != null){
                    _timer.stop()
                    _timer.removeEventListener(TimerEvent.TIMER, update)
                    _timer = null
                }
                for(i=0; i<_xNum * _yNum; i++){
                    _rectList[i].visible = _rectList[i].nextLiveFlg = false
                    if(_kaleidoscopeList[i] == 1){
                        _rectList[i].visible = _rectList[i].nextLiveFlg = true
                    }
                }
                _cube.rotationX = 45
                _cube.rotationY = -30
                _cube.rotationZ = 45
            }
            //
            _timer = new Timer(_interval)
            _timer.addEventListener(TimerEvent.TIMER, update)
            _timer.start()
            //
            _startBtn.removeEventListener(MouseEvent.CLICK, statLifeGame)
            _startBtn.visible = false
            //
            var meter:FPSMeter = new FPSMeter(this, 5, 0, "FPS");
            //addChild(new Stats());
            if(_pauseBtn == null) _pauseBtn = new PushButton(this, 180, 415, "PAUSE", pauseLifeGame);
            if(_label == null) _label = new Label(this, 350, 445, "Number of Life : 0");
            if(_radioBtn1 == null) _radioBtn1 = new RadioButton(this, 10, 413, "Interval : 0.05 sec", false, radioBtnSelect);
            if(_radioBtn2 == null) _radioBtn2 = new RadioButton(this, 10, 413+12, "Interval : 0.10 sec", true, radioBtnSelect);
            if(_radioBtn3 == null) _radioBtn3 = new RadioButton(this, 10, 413+12+12, "Interval : 0.30 sec", false, radioBtnSelect);
            if(_radioBtn4 == null) _radioBtn4 = new RadioButton(this, 10, 413+12+12+12, "Interval : 1.00 sec", false, radioBtnSelect);
            //
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown)
            stage.addEventListener(MouseEvent.MOUSE_UP, onUp)
            stage.addEventListener(Event.ENTER_FRAME, cubeUpdate)
        }
        
        private function pauseLifeGame(e:MouseEvent):void{
            if(_pauseBtn.label == "PAUSE"){
                _container.visible = true
                for(var i:int=0; i<_xNum * _yNum; i++){
                    _gridList[i].visible = true
                }
                _timer.stop()
                _pauseBtn.label = "RESTART"
                stage.removeEventListener(MouseEvent.MOUSE_DOWN, onDown)
                stage.removeEventListener(MouseEvent.MOUSE_UP, onUp)
                stage.removeEventListener(Event.ENTER_FRAME, cubeUpdate)
            }else{
                stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown)
                stage.addEventListener(MouseEvent.MOUSE_UP, onUp)
                stage.addEventListener(Event.ENTER_FRAME, cubeUpdate)
                _container.visible = false
                for(i=0; i<_xNum * _yNum; i++){
                    _gridList[i].visible = false
                }
                _timer.start()
                _pauseBtn.label = "PAUSE"
            }
        }
        
        private function radioBtnSelect(e:Event):void{
            if(_timer){
                _timer.stop()
                _timer.removeEventListener(TimerEvent.TIMER, update)
                _timer = null
            }
            switch(e.currentTarget){
                case _radioBtn1:
                    _interval = 50
                    break;
                case _radioBtn2:
                    _interval = 100
                    break;
                case _radioBtn3:
                    _interval = 300
                    break;
                case _radioBtn4:
                    _interval = 1000
                    break;
            }
            _timer = new Timer(_interval)
            _timer.addEventListener(TimerEvent.TIMER, update)
            if(_pauseBtn.label == "PAUSE") _timer.start()            
        }
        
        private function update(e:TimerEvent):void{
            var n:int
            for(var i:int=0; i<_xNum * _yNum; i++){
                _rectList[i].visible = _rectList[i].nextLiveFlg
                if(_rectList[i].visible == true) n++
            }
            for(i=0; i<_xNum * _yNum; i++){
                checkProp(_rectList[i])
                _rectList[i].colorChange()
            }
            _label.text = "Number of Life : "+n
        }
        
        private function checkProp(rect:Rect):void{
            var checkNum:int
            //
            if(rect.id > _xNum && rect.id % _xNum != 0) checkNum += singleCheck(_rectList[rect.id - _xNum - 1])
            if(rect.id > _xNum) checkNum += singleCheck(_rectList[rect.id - _xNum])
            if(rect.id > _xNum && rect.id % _xNum != _xNum-1) checkNum += singleCheck(_rectList[rect.id - _xNum + 1])
            if(rect.id > 0) checkNum += singleCheck(_rectList[rect.id - 1])
            if(rect.id < _xNum * _yNum-1) checkNum += singleCheck(_rectList[rect.id + 1])
            if(rect.id < _xNum * (_yNum-1)  && rect.id % _xNum != 0) checkNum += singleCheck(_rectList[rect.id + _xNum - 1])
            if(rect.id < _xNum * (_yNum-1)) checkNum += singleCheck(_rectList[rect.id + _xNum])
            if(rect.id < _xNum * (_yNum-1)-1 && rect.id % _xNum != _xNum-1) checkNum += singleCheck(_rectList[rect.id + _xNum + 1])
            //
            if(rect.visible == true){
                if(checkNum <= 1 || checkNum >= 4){
                    rect.nextLiveFlg = false
                }else{
                    rect.nextLiveFlg = true
                }
            }else{
                if(checkNum == 3){
                    rect.nextLiveFlg = true
                }else{
                    rect.nextLiveFlg = false
                }
            }
            //
            function singleCheck(r:Rect):int{
                if(r.visible){
                    return 1
                }else{
                    return 0
                }
            }
        }
        
        
        //PV3D
        private function init3D():void {
            initStage();
            initScene();
            initCamera();
            initDO3D();
            //
            _renderer.renderScene(_scene, _camera, _viewport);
        }
        
        private function initStage():void {
            _w = stage.stageWidth;
            _h = stage.stageHeight;
            _vpX = _w / 2;
            _vpY = _w / 2;
        }
        
        private function initScene():void{
            _renderer = new BasicRenderEngine();
            _scene = new Scene3D();
            _viewport  = new Viewport3D(0, 0, true, true);
            addChild(_viewport);
        }
        
        private function initCamera():void {
            _camera = new Camera3D();
            _camera.x = 0;
            _camera.y = 0;
            _camera.z = 1100;
            _camera.zoom = 25;
            _camera.focus = 25;
            _camera.target = DisplayObject3D.ZERO;
        }
        
        private function initDO3D():void {
            var materialList:MaterialsList = new MaterialsList({
                front: new BitmapMaterial(_bmd),
                back: new BitmapMaterial(_bmd),
                right: new BitmapMaterial(_bmd),
                left: new BitmapMaterial(_bmd),
                top: new BitmapMaterial(_bmd),
                bottom: new BitmapMaterial(_bmd)
            });
            _cube = new Cube(materialList, 450, 450, 450, 4, 4, 4);
            _cube.visible = false
            _scene.addChild(_cube);
            _cube.rotationY = 45
        }
    
        private function cubeUpdate(e:Event):void { 
            var X:Number = mouseX - _currentMouseX
            var Y:Number = mouseY - _currentMouseY
            if(_isDragging) {
                _cube.rotationY -= X/2
                _cube.rotationX += Y/2
                _currentMouseX = mouseX;
                _currentMouseY = mouseY;
            }
            _bmd.lock();
            _bmd.draw(_container)
            _bmd.unlock();
            _renderer.renderScene(_scene, _camera, _viewport);
        }
        
        private function onDown(e:MouseEvent):void {
            _isDragging = true;
            _currentMouseX = mouseX;
            _currentMouseY = mouseY;
        }
        
        private function onUp(e:MouseEvent):void {
            _isDragging = false;
        }
    }
}



//
import flash.display.Sprite;
import flash.display.Shape;
import flash.filters.BlurFilter;
import flash.filters.BevelFilter;

class Rect extends Sprite{
    private var _sh:Shape = new Shape()
    private var _id:int
    private var _lifeNum:int
    private var _blur:BlurFilter
    private var _bevel:BevelFilter
    public var nextLiveFlg:Boolean
    
    public function Rect(isLine:Boolean, isFill:Boolean){
        if(isLine) _sh.graphics.lineStyle(0,0xC0C0C0)
        if(isFill){
            _blur = new BlurFilter(2, 2, 1)
            _bevel = new BevelFilter(2, 90, 0xFFFFFF, 0.5, 0, 0.3, 4, 8)
            _sh.filters = [_blur, _bevel]
            _sh.graphics.beginFill(0xFF6600)
        }else{
            _sh.graphics.beginFill(0xFFFFFF)
        }
        _sh.graphics.drawRect(0, 0, 10, 10)
        _sh.graphics.endFill()
        addChild(_sh)
    }
    
    public function colorChange():void{
        if(this.visible){
            if(nextLiveFlg == true){
                switch(_lifeNum){
                    case 0:
                        setColor(0xFF6600) //生まれたて（オレンジ）
                        break;
                    case 1 :
                        setColor(0xFFCC00) //1世代生き延びた（黄色）
                        break;
                    case 2 :
                        setColor(0x003399) //2世代生き延びた（青）
                        break;
                    default :
                        setColor(0x009900) //安定状態（グリーン）
                        break;
                }
                _lifeNum++
            }else{
                setColor(0x990000) //次に死ぬ（レッド）
            }
        }else{
            _lifeNum = 0
        }
    }
    
    private function setColor(color:int):void{
        _sh.graphics.clear()
        _sh.graphics.lineStyle(0,0xC0C0C0)
        _sh.graphics.beginFill(color)
        _sh.graphics.drawRect(0, 0, 10, 10)
        _sh.graphics.endFill()
    }
    
    public function set id(n:int):void{
        _id = n
    }
    public function get id():int{
        return _id
    }
}

/*--- First Virsion ---

イギリスの数学者John Horton Conway博士が1970年に考案した
生命の誕生、進化、淘汰などのプロセスを簡易的なモデルで再現
したシミュレーションゲームである『ライフゲーム』を再現して
みました。

この『ライフゲーム』は単純に、セルに色が付いている時は「生」を、
色が付いていない時は「死」を表します。
生きているセルが死んだり、死んでいるセルから誕生するかは、
それぞれのセルの周囲にあるセル（合計8個）のセルによって
決まります。

ライフ進行（世代交代）によってセルが生きるか死ぬかの
法則（ルール？）は以下の通りです。

1. 現世代でセルが生きていて、周囲の生きているセルの数が１以下のとき
　　→ 次世代では過疎のため死にます。
2. 現世代でセルが生きていて、周囲の生きているセルの数が４以上のとき
　　→ 次世代では過密のため死にます。
3. 現世代でセルが生きていて、周囲の生きているセルの数が２または３のとき
　　→ 次世代でも生き残ります。
4. 現世代でセルが死んでいて、周囲の生きているセルの数が３のとき
　　→ 次世代で生が誕生します。
5. 現世代でセルが死んでいて、周囲の生きているセルの数が３でないとき
　　→ 次世代でも死んだままです。

この世代交代を繰り返す間に白黒のグリッドはいろんな模様に変化し
その中には有名なパターンもいくつかあるそうです。

と、書いておきながら実は僕もそこまで詳しくは知りませんので…
http://ja.wikipedia.org/wiki/ライフゲーム
でも参照してみて下さい。シンプルながら結構奥が深いです。

でもこれ、見た目シンプルなくせに重いし、
それよりなにより、きちんとロジック通りに動いているかが心配です。
*/