/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/daph
 */

// forked from sakef's レインボーロード！  forked from: nengafl
// forked from nengafl's nengafl
/*
   PV3Dで簡単に綺麗な図形を作ってみよう！

   PV3Dを使うと3Dを超簡単に扱えます。
   そこで、PV3Dで簡単に綺麗な図形を作ってみましょう。
   簡単な数式とパラメータだけで綺麗な図形が完成！
   下で定義してある定数のp, q, a, l, m をいじってみてください。
   
   また、for文の中の数式を書き換えるとさらに形が変わります。
   単純に、sin → cos みたいに書き換えてみてもおもしろいかも！
*/
 
 
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.events.Event;
    import flash.geom.Matrix;
    import frocessing.color.FColor;
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.BitmapEffectLayer;

    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="30")]
    public class Nengafl extends BasicView
    {
        // 計算に使うパラメータ
        // このあたりを適当に変えてみるだけでも面白いです！
        //----------------------------------------------------------------
        private const p:int=3;
        private const q:int=7;
        private const a:int=100;
        private const l:Number=0.9;
        private const m:Number=1.1;
        //----------------------------------------------------------------

        private var pixels:Pixels;
        private var canvas:BitmapData;
        private var mtx:Matrix;

        // コンストラクタ
        public function Nengafl()
        {
            super(0, 0, true, true);

            // レイヤー作成。PV3Dでエフェクト使うときはこれを最初に作ります
            var layer:BitmapEffectLayer=new BitmapEffectLayer(viewport, 465, 465, true, 0, "clear_pre", true);
            layer.clearBeforeRender=true;
            viewport.containerSprite.addLayer(layer);

            camera.z=-500;

            // Pixelsの初期化
            pixels=new Pixels(layer);
            scene.addChild(pixels);

            var c:int=0;
            var cc:FColor=new FColor;

            // パラメータと数式でPixelの位置を計算する
            for (var i:Number=0; i <= 6 * Math.PI; i+=0.02)
            {
                // 数式に従ってx, y, z を計算。ここを適当に変えてみても面白いです。
                // 簡単にsin → cos に変えてみるとか！
                var xx:Number=(2 + Math.cos(q / p * i)) * Math.cos(i) * a;
                var yy:Number=Math.sin(q / p * i) * a * 1.6;
                var zz:Number=(2 + Math.cos(q / p * i)) * Math.sin(i) * a;

                // 綺麗なグラデーションになるように色を設定
                // こういうときはHSVを使うのが便利です
                cc.hsv(c, 1, 1);
                var color:uint=cc.value32;

                for (var j:int=0; j < m; j++)
                {
                    // x, y, z を l～mの範囲で散らします。
                    // l～mの区間の乱数を出す計算：(m - 1) * Math.random() + 1
                    var px:Pixel3D=new Pixel3D(color, xx * ((m - 50) * Math.random() + 50), yy * ((m - 50) * Math.random() + 50), zz * ((m - 50) * Math.random() + 50));
                    pixels.addPixel3D(px);
                }
                c+=2;
            }

            // キラキラロジック
            canvas=new BitmapData(465 / 4, 465 / 4, false, 0x000000);
            var bmp:Bitmap=new Bitmap(canvas, "never", true);
            bmp.scaleX=bmp.scaleY=4;
            bmp.smoothing=true;
            bmp.blendMode=BlendMode.ADD;
            addChild(bmp);
            mtx=new Matrix(0.25, 0, 0, 0.25);

            // フレームイベント追加
            addEventListener(Event.ENTER_FRAME, onFrame);
        }

        // フレームイベント用関数
        private function onFrame(e:Event):void
        {
            // キラキラを描写
            canvas.fillRect(canvas.rect, 0x000000);
            canvas.draw(viewport, mtx);

            // Y軸でローテーション
            pixels.rotationY+=0.2;
            
            // レンダリング！
            singleRender();
        }
    }
}