/**
 * Copyright meemeer ( http://wonderfl.net/user/meemeer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/daEm
 */

/*
 * AmfConnectのgatewayUrlに
 * 適切なamf環境を指定しないと動きません...
 * http://meemeer.sitemix.jp/blog/?p=359
 *
 */
package 
{
    import com.bit101.components.*;
    import flash.display.Sprite;
    import flash.events.Event;
    import jp.progression.commands.lists.*;
    import jp.progression.commands.net.*;
    
    /**
     * ...
     * @author meemeer
     */
    [SWF(width="465", height="465", frameRate="60")]
    public class Main extends Sprite 
    {
        private var list:List;
        private var id:Text;
        private var title:Text;
        private var body:Text;
        private var button:PushButton;
        private var delId:Text;
        private var del:PushButton;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            start();
        }
        
        private function start():void
        {
            var label:Label = new Label(this, 10, 10, 'CakePHP Blog Tutorial');
            label.scaleX = label.scaleY = 3.0;
            Style.embedFonts = false;
            Style.fontSize = 12;
            list = new List(this, 10, 70);
            list.alternateRows = true;
            list.width = 445;
            var postLavel:Label = new Label(this, 220, 190, 'ID:空欄、存在しなければ新規、あれば変更');
            var titleLabel:Label = new Label(this, 220, 225, '件名:');
            var bodyLabel:Label = new Label(this, 220, 260, '本文:');
            id = new Text(this, 10, 190);
            id.width = 25;
            id.height = 25;
            title = new Text(this, 10, 225);
            title.width = 200;
            title.height = 25;
            body = new Text(this, 10, 260);
            body.width = 200;
            body.height = 100;
            body.mouseEnabled;
            button = new PushButton(this, 220, 340, "Post", addPost);
            delId = new Text(this, 10, 375);
            delId.width = 25;
            delId.height = 25;
            del = new PushButton(this, 220, 375, "削除", delPost);
            
            new ParallelList(null,
                function():void { setList(); }
            ).execute();
        }
        
        private function setList():void
        {
            list.removeAll();
            new Amf('PostsController.find_all',
                function(res:Object):void {
                    trace(res, 'falseなら０件');
                    res.sortOn('id', Array.CASEINSENSITIVE | Array.NUMERIC);
                    for each (var posts:Post in res) {
                        list.addItem( { label:"[ID] : " + posts.id + " [タイトル] : " + posts.title + "  [本文] : " + posts.body } );
                    }
                },
                {
                    onStart:function():void {
                        trace('amf start');
                    },
                    onComplete:function():void {
                        trace('amf end');
                    }
                },
                null
            ).execute();
        }
        
        private function addPost(e:Event):void
        {
            var post:Post = new Post();
            post.id = int(id.text) || null;
            post.title = title.text;
            post.body = body.text;
            
            button.enabled = false;
            new Amf('PostsController.save',
                function(res:Object):void {
                    trace(res);
                    for each (var post:Post in res) {
                        trace(post.id, '追加したpostID');
                    }
                },
                {
                    onStart:function():void {
                        trace('amf start');
                    },
                    onComplete:function():void {
                        trace('amf end');
                        setList();
                        button.enabled = true;
                        post = null;
                    }
                },
                post
            ).execute();
        }
        
        private function delPost(e:Event):void
        {
            var post:Post = new Post();
            post.id = int(delId.text) || null;
            
            new Amf('PostsController.destroy',
                function(res:Object):void {
                    trace(res, "falseなら失敗");
                },
                {
                    onStart:function():void {
                        trace('amf start');
                    },
                    onComplete:function():void {
                        trace('amf end');
                        setList();
                        post = null;
                    }
                },
                post
            ).execute();
        }
        
    }
    
}

import flash.net.registerClassAlias;

registerClassAlias('Post', Post);
class Post
{
    public var id:int;
    public var title:String;
    public var body:String;
    public var created:String;
    public var modified:String;
    
    public function Post()
    {
        
    }
}

import flash.events.Event;
import flash.net.Responder;
import jp.progression.casts.*;
import jp.progression.commands.display.*;
import jp.progression.commands.lists.*;
import jp.progression.commands.net.*;
import jp.progression.commands.tweens.*;
import jp.progression.commands.*;
import jp.progression.data.*;
import jp.progression.events.*;
import jp.progression.scenes.*;

/**
 * AMF接続を行うコマンド側
 * new AMF('[接続先のclass.function]', '[callback]', initObject, '... [引数]').execute();
 * @author m_emem
 * 
 * @version 0.0.1
 * @see http://meemeer.sitemix.jp/blog/
 * @see http://meemeer.sitemix.jp/blog/?p=7
 */
class Amf extends Command 
{
    private var _amf:AmfConnect;
    private var _func:String;
    private var _args:Object;
    private var _callback:Function;
    
    /**
     * 新しい AmfCommand インスタンスを作成します。
     */
    public function Amf( func:String, callback:Function, initObject:Object = null, ... args:Array ) 
    {
        _func = func;
        _callback = callback;
        _args = args;
        
        // 親クラスを初期化します。
        super( _execute, _interrupt, initObject );
    }
    
    /**
     * 実行されるコマンドの実装です。
     */
    private function _execute():void 
    {
        _amf = AmfConnect.instance;
        _amf.dispatcher.addEventListener(Event.COMPLETE, _complete, false, 0, true);
        
        var params:Array = [_func, _callback];
        params.push.apply(params, _args);
        _amf.execute.apply(_amf, params);
        
        // 
        //executeComplete();
    }
    
    /**
     * 中断されるコマンドの実装です。
     */
    private function _interrupt():void 
    {
    }
    
    private function _complete(e:Event):void
    {
        _amf.dispatcher.removeEventListener(Event.COMPLETE, _complete);
        latestData = _amf.data;
        
        _amf.data = null;
        _func = null;
        _callback = null;
        _args = null;
        
        if (_amf.error != null) {
            super.throwError(this, new Error(_amf.error));
        } else {
            super.executeComplete();
        }
    }
    
    /**
     * インスタンスのコピーを作成して、各プロパティの値を元のプロパティの値と一致するように設定します。
     */
    public override function clone():Command 
    {
        return new Amf( _func, _callback, this, _args );
    }
}


import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IEventDispatcher;
import flash.events.NetStatusEvent;
import flash.net.NetConnection;
import flash.net.ObjectEncoding;
import flash.net.Responder;

/**
 * AMF接続を行うAMF設定側
 * @author m_emem
 * 
 * @version 0.0.1
 * @see http://meemeer.sitemix.jp/blog/
 * @see http://meemeer.sitemix.jp/blog/?p=7
 */
class AmfConnect
{
    private static var _instance:AmfConnect;
    public var dispatcher:IEventDispatcher;
    public var nc:NetConnection;
    public var error:Object;
    
    private var gatewayUrl:String = '';
    private var callback:Function;
    public var data:Object;
    
    public function AmfConnect() 
    {
        if (_instance === null) {
            _instance = this;
            init();
        } else {
            throw new Error('Singleton class');
        }
    }
    
    public static function get instance():AmfConnect
    {
        if (_instance === null) {
            _instance = new AmfConnect();
        }
        return _instance;
    }
    
    private function init():void
    {
        dispatcher = new EventDispatcher();
        error = null;
        
        nc = new NetConnection();
        nc.objectEncoding = ObjectEncoding.AMF3;
        nc.addEventListener(NetStatusEvent.NET_STATUS, onNetStatus);
        nc.connect(gatewayUrl);
    }
    
    private function onNetStatus(e:NetStatusEvent):void 
    {
        trace("Connection error, error code: (" +e.info.code + ")", "System message");
    }
    
    public function execute(_func:String, _callback:Function, ... _args:Array):void
    {
        callback = _callback;
        
        var params:Array = [_func, new Responder(onResultHandler, onFaultHandler)];
        params.push.apply(params, _args);
        nc.call.apply(nc, params);
    }
    
    private function onResultHandler(result:Object):void
    {
        if (callback != null) {
            data = callback.call(null, result);
        } else {
            data = result;
        }
        dispatcher.dispatchEvent(new Event(Event.COMPLETE));
    }
    
    private function onFaultHandler(fault:Object):void
    {
        data = fault;
        error = 'discription: ' + fault.description + ' code: ' + fault.code + ' details: ' + fault.details + ' level: ' + fault.level + ' line: ' + fault.line;
        dispatcher.dispatchEvent(new Event(Event.COMPLETE));
    }
    
}