/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dYx8
 */

package {
	import adobe.utils.CustomActions;
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.geom.Matrix;
	import flash.geom.ColorTransform;
	import flash.display.BlendMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	[SWF(width = 465, height = 465, backgroundColor = 0, frameRate = 30)]
	public class BitmapDataSmaple6 extends Sprite {
		private var bmpdata:BitmapData;
		private var sprite:Sprite;
		private var matrix:Matrix;
		private var colortrans:ColorTransform;
		private var bmpcolortrans:ColorTransform;
		
		public function BitmapDataSmaple6():void {
			bmpdata = new BitmapData(465, 465, false, 0);
			addChild(new Bitmap(bmpdata));
			sprite = newFig(0, 0, 40, 0xffffff);
			matrix = new Matrix();
			colortrans = new ColorTransform();
			bmpcolortrans = new ColorTransform(0.99, 0.99, 0.99);
			addEventListener(Event.ENTER_FRAME, enterframe);
			stage.addEventListener(MouseEvent.CLICK, reset);
		}
		
		private function enterframe(e:Event):void {
			bmpdata.colorTransform(bmpdata.rect, bmpcolortrans);
			matrix.identity();
			var s:Number = Math.random() * 2;
			matrix.scale(s, s);
			matrix.rotate(Math.PI * Math.random());
			matrix.translate(mouseX, mouseY);
			colortrans.greenMultiplier = mouseX / 465;
			colortrans.blueMultiplier = mouseY / 465;
			colortrans.alphaMultiplier = Math.random();
			bmpdata.draw(sprite, matrix, colortrans, BlendMode.ADD);
		}
		
		private function reset(e:MouseEvent):void {
			bmpdata.fillRect(bmpdata.rect, 0xff000000);
		}
		
		private function newFig(cx:Number, cy:Number, size:Number, col:uint):Sprite {
			var shape:Sprite = new Sprite();
			shape.graphics.lineStyle(0, 0x000000, 0.3);
			shape.graphics.beginFill(col);
			shape.graphics.drawCircle(cx, cy, size * 0.5);
			shape.graphics.drawCircle(cx, cy, size * 0.4);
			var w:Number = size * 0.6;
			var h:Number = size * 0.15;
			shape.graphics.drawRect(cx - w / 2, cy - h / 2, w,h);
			shape.graphics.endFill();
			return shape;
		}
	}
}