/**
 * Copyright TylerS ( http://wonderfl.net/user/TylerS )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dYdA
 */

package{
	
	import flash.display.Sprite;
	import flash.events.Event;
	// Classes used in this example
	import Box2D.Dynamics.*;
	import Box2D.Collision.*;
	import Box2D.Collision.Shapes.*;
	import Box2D.Common.Math.*;
	
	public class HelloWorld extends Sprite{
		
		public function HelloWorld(){
			
			
			
			// Add event for main loop
			addEventListener(Event.ENTER_FRAME, Update, false, 0, true);
			
			
			
			// Creat world AABB
			var worldAABB:b2AABB = new b2AABB();
			worldAABB.lowerBound.Set(-100.0, -100.0);
			worldAABB.upperBound.Set(100.0, 100.0);
			
			// Define the gravity vector
			var gravity:b2Vec2 = new b2Vec2(0.0, 10.0);
			
			// Allow bodies to sleep
			var doSleep:Boolean = true;
			
			// Construct a world object
			m_world = new b2World(worldAABB, gravity, doSleep);
			
			// set debug draw
			/*var dbgDraw:b2DebugDraw = new b2DebugDraw();
			var dbgSprite:Sprite = new Sprite();
			addChild(dbgSprite);
			dbgDraw.m_sprite = dbgSprite;
			dbgDraw.m_drawScale = 30.0;
			dbgDraw.m_fillAlpha = 0.0;
			dbgDraw.m_lineThickness = 1.0;
			dbgDraw.m_drawFlags = 0xFFFFFFFF;
			m_world.SetDebugDraw(dbgDraw);*/
			
			
			
			// Vars used to create bodies
			var body:b2Body;
			var bodyDef:b2BodyDef;
			var boxDef:b2PolygonDef;
			var circleDef:b2CircleDef;
			
			
			
			// Add ground body
			bodyDef = new b2BodyDef();
			//bodyDef.position.Set(15, 19);
			bodyDef.position.Set(10, 12);
			//bodyDef.angle = 0.1;
			boxDef = new b2PolygonDef();
			boxDef.SetAsBox(30, 3);
			boxDef.friction = 0.3;
			boxDef.density = 0; // static bodies require zero density
			/*circleDef = new b2CircleDef();
			circleDef.radius = 10;
			circleDef.restitution = 0.2*/
			// Add sprite to body userData
			bodyDef.userData = createBox();
			//bodyDef.userData = new PhysCircle();
			bodyDef.userData.width = 30 * 2 * 30; 
			bodyDef.userData.height = 30 * 2 * 3; 
			addChild(bodyDef.userData);
			body = m_world.CreateBody(bodyDef);
			body.CreateShape(boxDef);
			//body.CreateShape(circleDef);
			body.SetMassFromShapes();
			
			circleDef = new b2CircleDef();
					circleDef.radius = 1;
					circleDef.density = 1.0;
					circleDef.friction = 0.5;
					circleDef.restitution = 0.2
					bodyDef.userData = createCircle();
					bodyDef.userData.width = 1 * 2 * 30; 
					bodyDef.userData.height = 1 * 2 * 30; 
					body = m_world.CreateBody(bodyDef);
					body.CreateShape(circleDef);
				body.SetMassFromShapes();
				addChild(bodyDef.userData);
			
			
		}
		
		public function createCircle():Sprite {
            var s:Sprite = new Sprite();
            s.graphics.beginFill(0xFF0000);
            s.graphics.drawCircle(-25,-25,50);
            s.graphics.endFill();
            return s;
		}
		
		public function createBox():Sprite {
            var s:Sprite = new Sprite();
            s.graphics.beginFill(0x00FF00);
            s.graphics.drawRect(-25,-25,50, 50);
            s.graphics.endFill();
            return s;
		}
		
		public function Update(e:Event):void{
			
			m_world.Step(m_timeStep, m_iterations);
			
			// Go through body list and update sprite positions/rotations
			for (var bb:b2Body = m_world.m_bodyList; bb; bb = bb.m_next){
				if (bb.m_userData is Sprite){
					bb.m_userData.x = bb.GetPosition().x * 30;
					bb.m_userData.y = bb.GetPosition().y * 30;
					bb.m_userData.rotation = bb.GetAngle() * (180/Math.PI);
				}
			}
			
		}
		
		public var m_world:b2World;
		public var m_iterations:int = 10;
		public var m_timeStep:Number = 1.0/30.0;
		
	}

}