/**
 * Copyright 0xABCDEF ( http://wonderfl.net/user/0xABCDEF )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dXz9
 */

// forked from xoul's Flower
package
{
    import flash.display.StageQuality;
    import flash.geom.ColorTransform;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.Shape;
    
    public class FlashTest extends Sprite
    {
        private var _pencil : Shape;
        private var _canvas : BitmapData;
        
        private var _lastMouseX : Number = 0;
        private var _lastMouseY : Number = 0;
        
        private var _heads : Vector.<Head>;
        
        private var _whiteTransform : ColorTransform;
        
        public function FlashTest()
        {
           stage.quality = StageQuality.LOW;
            
           _pencil = new Shape;
           _canvas = new BitmapData( stage.stageWidth, stage.stageHeight, false, 0xFFFFFF );
           addChild( new Bitmap( _canvas ) );
           
           _heads = new Vector.<Head>( 100, true );
           var len : int = _heads.length;
           for( var i : int = 0; i < len; i++ )
               _heads[i] = new Head;
           
           stage.addEventListener( MouseEvent.MOUSE_MOVE, onMouseMove );
           stage.addEventListener( Event.ENTER_FRAME, onEnterFrame );
           
           _whiteTransform = new ColorTransform( 1, 1, 1, 1, 0x1f, 0x1f, 0x1f );
           
           _lastMouseX = mouseX;
           _lastMouseY = mouseY;
        }
        
        private function onMouseMove( e : MouseEvent ) : void
        {        
            var len : int = _heads.length;
            for( var i : int = 0; i < len; i++ )
            {
                if( !_heads[i].shooted )
                {
                    shoot( _heads[i], Math.atan2( mouseY - _lastMouseY, mouseX - _lastMouseX ) );
                    break;
                }
            }
            
            _lastMouseX = mouseX;
            _lastMouseY = mouseY;
        }
        
        private function onEnterFrame( e : Event ) : void
        {
            _canvas.colorTransform( _canvas.rect, _whiteTransform );
            
            var len : int = _heads.length;
            _pencil.graphics.clear();
            for( var i : int = 0; i < len; i++ )
            {
                var head : Head = _heads[i];
                if( head.shooted )
                {
                    var lastX : Number = head.x;
                    var lastY : Number = head.y;
                    head.x += head.radius * Math.cos( head.direction );
                    head.y += head.radius * Math.sin( head.direction );

                    if( Math.random()>0.9 ) head.dDir *= -1;
                    if( head.rightOrLeft ) head.direction -= head.dDir;
                    else head.direction += head.dDir;
                    head.radius -= .5;
                    
                    if( head.radius <= 0 )
                    {
                        head.shooted = false;
                    }
                    
                    with( _pencil.graphics )
                    {
                        lineStyle( head.radius/3, head.color );
                        moveTo( lastX, lastY );
                        lineTo( head.x, head.y );
                    }
                    _canvas.draw( _pencil );
                    
                }
            }

        }
        
        private function shoot( head : Head, direction : Number ) : void
        {
            head.shooted = true;
            head.x = _lastMouseX;
            head.y = _lastMouseY;
            head.direction = direction;
            head.dDir = Math.random();
            head.radius = Math.random() * 20 + 5;
            head.rightOrLeft = Math.random() < .5;
            head.color = Math.random() * 0xFFFFFF;
        }
    }
}

class Head
{
    public var x : Number;
    public var y : Number;
    public var radius : Number;
    public var direction : Number;
    public var dDir : Number;
    public var rightOrLeft : Boolean;
    public var shooted : Boolean;
    public var color : uint;
}
