/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dXkz
 */

// forked from fukt's forked from: Moving Square
// forked from Yuichi's Moving Square
package {
    import flash.events.Event;
    import flash.display.Sprite;
    import caurina.transitions.Tweener;
    
    public class Main extends Sprite {
        private var w:Number;
        private var h:Number;
        private var s:Square;
        
        public function Main() {
            init();
            run([
                {x:w*7/8, y:h*7/8, scaleX:1/4, scaleY:1/4,              time:0.5},
                {x:w/2,   y:h/2,   scaleX:1,   scaleY:1,                time:0.5},
                {                                          rotation:90, time:0.5},
                {                  scaleX:1/4, scaleY:1/4,              time:0.5},
                {                                          rotation:0,  time:0.5},
                {x:w/4,   y:h*3/4, scaleX:1/2, scaleY:1/2,              time:0.5},
                {x:w/2,   y:h*7/8, scaleX:1,   scaleY:1/4,              time:0.5},
                {x:w/8,   y:h/2,   scaleX:1/4, scaleY:1,                time:0.5},
                {x:w/8,   y:h/8,               scaleY:1/4,              time:0.5}
            ]);
        }
        
        private function init():void {
            w = stage.stageWidth;
            h = stage.stageHeight;
            
            s = new Square(0x0000ff, w, h);
            s.x = s.width / 2;
            s.y = s.height / 2;
            s.scaleX = 1 / 4;
            s.scaleY = 1 / 4;
            addChild(s);
        }
        
        private function run(queue:Array):void {
            var i:int;
            for(i = queue.length - 2; i >= 0; i--){
                queue[i].onComplete = Tweener.addTween;
                queue[i].onCompleteParams = [s, queue[i + 1]];
            }
            queue[queue.length - 1].onComplete = Tweener.addTween;
            queue[queue.length - 1].onCompleteParams = [s, queue[0]];
            Tweener.addTween(s, queue[0]);
        }
    }
}

import flash.display.Sprite;

class Square extends Sprite {
    private var _w:Number;
    private var _h:Number;
    private var _color:uint;
    
    public function Square(color:uint, width:Number, height:Number) {
        _color = color;
        _w = width;
        _h = height;
        draw();
    }
    
    public function get color():uint {
        return _color;
    }

    public function set color(value:uint):void{
        _color = value;
        draw();
    }
    
    private function draw():void {
        graphics.clear();
        graphics.beginFill(_color);
        graphics.drawRect(-_w / 2, -_h / 2, _w, _h);
        graphics.endFill();
    }
}
