/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dXOI
 */

/*
ステージをクリックでパーティクル発生
*/
package  {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(width="465", height="465", backgroundColor="#FFFFFF", frameRate="30")]
    
    public class Main extends Sprite{

        public function Main() {
            stage.addEventListener(MouseEvent.MOUSE_DOWN, go)
        }
        
        private function go(e:MouseEvent):void{
            for(var i:int=0;i<30;i++){
                var n:int = Math.floor(Math.random()*49+1)
                var n2:Number = Math.random()*4-2
                var n3:Number = Math.random()*100-50
                var _circle:Circle = new Circle(n, n2, Math.floor(Math.random()*2))
                addChild(_circle)
                _circle.x = mouseX+n3
                _circle.y = mouseY+n3
                _circle.addEventListener(Event.ENTER_FRAME, _circle.drop)
            }
        }
    }
}


import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point;
import flash.geom.ColorTransform;

class Circle extends Sprite{
    
    private var _size:int
    private var _speed:Number
    private var _v:Point = new Point(0,0)
    private var _k:Number = 0.9
    private var _ground:int = 465
    private var _vec:uint
    
    public function Circle(size:int, speed:Number, vec:uint=0){
        graphics.beginFill(0xC00000)
        graphics.drawCircle(0,0,size)
        graphics.endFill()
        _speed = speed
        _size = size
        _vec = vec
        this.mouseChildren = false
    }
    
    public function drop(e:Event):void{
        var n:Number
        if(_vec==0){
            n = _v.x+e.target.width/200
            _v.x = n
        }else{
            n = _v.x-e.target.width/200
            _v.x = n
        }
        e.target.x += _v.x;  
            _v.y += _speed;  
        if(e.target.y > (_ground-_size) && _v.y > 0 ){ 
            _v.y = -_v.y*_k;  
        }  
        e.target.y += _v.y; 
        //
        if(e.target.x>1000 || e.target.x<-300|| e.target.y<-300) e.target.removeEventListener(Event.ENTER_FRAME, drop)
    }
}