/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dWu3
 */

// forked from tepe's forked from: forked from: キーボード表示
// forked from tepe's forked from: キーボード表示
// forked from tepe's キーボード表示
package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.net.*;
    import flash.ui.*;
    import flash.utils.getTimer;
    import flash.system.*;
 
    public class FlashTest extends Sprite {
        private var kb:KeyBoardBtn = new KeyBoardBtn();
        private var txt:TextField = new TextField();
        private var base:Sprite = new Sprite();
        
        public function FlashTest(){
            base.y = 300;
            addChild(base);
            addChild(kb);
            //txt.text = Keyboard.physicalKeyboardType;
            kb.x = 10; kb.y = 20;
            kb.scaleX = kb.scaleY = 1.2;
            //kb._charset1 = "ё1234567890-= йцукенгшщзхъфывапролджэ\ячсмитьбю.  ";
            //kb._charset2 = "Ё!\"№;%:?*()_+ ЙЦУКЕНГШЩЗХЪФЫВАПРОЛДЖЭ/ЯЧСМИТЬБЮ,  ";
            addChild(txt);
            txt.y=200;
            //stage.addEventListener(MouseEvent.CLICK,onClick);
            //stage.addEventListener(KeyboardEvent.KEY_DOWN,onKey);
 
        }
        private function onClick(e:MouseEvent):void{
            txt.text = kb.text;
            txt.scrollH = txt.maxScrollH;
        }
        

        private function onKey(e:KeyboardEvent):void{
            txt.text = kb.text;
            if(Capabilities.hasIME){
                IME.enabled = false;
            }
            txt.scrollH = txt.maxScrollH;
            
        }
        



    }
}





//USキーボードのレイアウト

//キーレイアウト
//出力文字
//キーコード




/////////////////////////////////////////////////////////
//    キーボード表示
/////////////////////////////////////////////////////////
import flash.system.*;
import flash.events.*;
import flash.ui.*;
class KeyBoardBtn extends Sprite{
    private var btn:Btn;
    
    private var _caps:Boolean = false;
    private var _ctrl:Boolean = false;
    private var _shift:Boolean = false;
    
    private var keyList:Array = new Array();
    private var keyLength:int;//キーの数
    private var _color1:uint = 0x0000ff;
    private var _color2:uint = 0xffffff;//キーボードベースカラー
    
    public var _charset1:String = " 1234567890-^￥qwertyuiop@[asdfghjkl;:]zxcvbnm,./\\";
    public var _charset2:String = " !\"#$%&'() =~|QWERTYUIOP`{ASDFGHJKL+*}ZXCVBNM<>?_"; 
    private var _text:String = new String();
    
    
    public function KeyBoardBtn():void{
        addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    
    private function init(e:Event=null):void{        
        //var keyName:String;
        var i:int;
        
        graphics.beginFill(_color2);
        graphics.drawRoundRect(-5,-5,384,130,5);

        // BackSpace
        btn = new Btn();
        btn.name = "8";
        btn.x = 350;        btn.y = 0;
        btn.text = "Bs"; 
        
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            _text = _text.substr(0,_text.length-1);
        });
       
        // Tab
        btn = new Btn(30);
        btn.name = "9";
        btn.x = 0;        btn.y = 25;
        btn.text = "Tab"; 
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            _text += "\t";
        });
        
        // Enter
        btn = new Btn(30,45,true);
        btn.name = "13";
        btn.x = 340;        btn.y = 25;
        btn.text = "Enter"; 
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            _text += "\r";
        });
 
        // Caps Lock
        btn = new Btn(40);
        btn.name = "240";
        btn.x = 0;        btn.y = 50;
        //btn.text = "Caps"; 
        addChild(btn);
        keyList.push(btn);
        
        // Shift (左)    
        btn = new Btn(54);
        btn.name = "16";
        btn.x = 0;        btn.y = 75;
        btn.text = "Shift"; 
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            if(_shift==false){
                shift = true;
                getKey("16").setLight(true);
            }
            else{ 
                shift = false;
                getKey("shift").setLight(false);
                getKey("16").setLight(false);
            }
            
        });
        
        // Shift (右)
        btn = new Btn(35);
        btn.name = "shift";
        btn.x = 335;        btn.y = 75; 
        btn.text = "Shift"; 
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            if(_shift==false){
                shift = true;
                getKey("shift").setLight(true);
            }
            else{ 
                shift = false;
                getKey("shift").setLight(false);
                getKey("16").setLight(false);
            }
        });
      
        // Ctrl (左)
        btn = new Btn(30);
        btn.name = "17";
        btn.x =0;        btn.y = 100;
        btn.text = "Ctrl";
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            if(_ctrl==false){
                _ctrl = true;
                getKey("17").setLight(true);
            }
            else{ 
                _ctrl = false;
                getKey("ctrl").setLight(false);
                getKey("17").setLight(false);
            }
        });
        
        // Ctrl (右)
        btn = new Btn(30);
        btn.name = "ctrl";
        btn.x =340;        btn.y =100;
        btn.text = "Ctrl";
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            if(_ctrl==false){
                _ctrl = true;
                getKey("ctrl").setLight(true);
            }
            else{ 
                _ctrl = false;
                getKey("ctrl").setLight(false);
                getKey("17").setLight(false);
            }
        });
 
        // space
        btn = new Btn(120);
        btn.name = "32";
        btn.x =110;        btn.y =100;
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            _text += " ";
        });
        
        
        // 半角/全角
        btn = new Btn();
        btn.name = "244";
        btn.x = 0;        btn.y = 0; 
        addChild(btn);
        keyList.push(btn);

        

        
        var key:Array = new Array();
        key.push("49"); key.push("50"); key.push("51"); key.push("52"); key.push("53");
        key.push("54"); key.push("55"); key.push("56"); key.push("57"); key.push("48");
        key.push("189"); key.push("222"); key.push("220");   
        
        
        for(i=0;i<13;i++){
            btn = new Btn();
            btn.name = key[i];
            btn.x = i*25+25;            btn.y = 0;
            addChild(btn);
            keyList.push(btn);
            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown);
        }
        
        key = new Array();
        key.push("81"); key.push("87"); key.push("69"); key.push("82"); key.push("84");
        key.push("89"); key.push("85"); key.push("73"); key.push("79"); key.push("80");
        key.push("192"); key.push("219");
        
            
        for(i=0;i<12;i++){
            btn = new Btn();
            btn.name = key[i];
            btn.x = i*25+37;            btn.y = 25;
            addChild(btn);
            keyList.push(btn);
            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown);
        }
        
        key = new Array();
        key.push("65"); key.push("83"); key.push("68"); key.push("70"); key.push("71");
        key.push("72"); key.push("74"); key.push("75"); key.push("76"); key.push("187");
        key.push("186"); key.push("221");    
            
        for(i=0;i<12;i++){
            btn = new Btn();
            btn.name = key[i];
            btn.x = i*25+45;            btn.y = 50;
            addChild(btn);
            keyList.push(btn);
            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown);
        }
        
        key = new Array();
        key.push("90"); key.push("88"); key.push("67"); key.push("86"); key.push("66");
        key.push("78"); key.push("77"); key.push("188"); key.push("190"); key.push("191");
        key.push("226");
            
        for(i=0;i<11;i++){
            btn = new Btn();
            btn.name = key[i];
            btn.x = i*25+60;            btn.y = 75;
            addChild(btn);
            keyList.push(btn);
            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown); 
        }
        
        shift = false;
        
        keyLength = keyList.length;
        stage.addEventListener(KeyboardEvent.KEY_DOWN,onKey);
        stage.addEventListener(KeyboardEvent.KEY_UP,offKey);
        stage.stageFocusRect = false;
        color = 0x0000ff;


        getKey("70").setMarker();
        getKey("74").setMarker();

    }// init
    

    
    private function onKey(e:KeyboardEvent):void{
        var name:String = e.keyCode.toString();            
        
        if(0 < e.keyLocation){
            if(e.shiftKey==true)shift=true;
            //if(e.ctrlKey==true)ctrl=true;
        }

        
        if(1 < e.keyLocation){
            if(e.keyCode==16)getKey("shift")._down();
            if(e.keyCode==17)getKey("ctrl")._down();
        }
        if(e.keyLocation == 0){

            if(e.shiftKey==true){ 
                shift=true;
                getKey("shift")._down();
            }
            if(e.ctrlKey==true){ 
                //ctrl=true;
                getKey("ctrl")._down();
            }

            getKey(name)._down();
            if(33<=e.charCode && e.charCode<=126 && getKey(name).text!=" ")_text += getKey(name).text;
            //スペース
            if(e.keyCode == 32)_text += " ";
            //バックスペース
            if(e.keyCode == 8 && 0<_text.length)_text = _text.substring(0,_text.length-1);
            //エンター
            if(e.keyCode == 13)_text += "\n";
            //半角/全角
            if(e.keyCode == 244)_text += getKey(name).text;
            //タブ
            if(e.keyCode == 9)_text += "\t";
        }
    }
    
    public function set color(col:uint):void{
        _color1 = col;
        for(var i:int=0;i<keyLength;i++){
            var key:Object = getKey2(i);
            key.setColor(_color1);
            
        }

    }

    
    public function offKey(e:KeyboardEvent):void{
            var name:String = e.keyCode.toString();
            getKey(name)._up();
            if(name == "16")getKey("shift")._up();
            if(name == "17")getKey("ctrl")._up();
            //if(name == "13")kb.getBtn("enter")._up();
            if(e.shiftKey==false)shift=false;
        }

    
    private function set shift(b:Boolean):void{
        
            var char:String;
            _shift = b;
            if(_shift==true)char = _charset2;
            else char = _charset1;

            for(var i:int=11-2;i<=59-2;i++){
                var key:Object = getKey2(i);
                key.text = char.charAt(i-11+2); 
            }
    }
    
    public function get length():int{
        return keyLength;
    }

    public function getKey2(keyNum:int):Object{
        return keyList[keyNum];
    }


    
    public function getKey(name:String):Object{
        //return this.btn.getChildByName(name); 
        return this.getChildByName(name);
    }


    
    private function onKeyDown(e:MouseEvent):void{
            _text += e.currentTarget.text;
    }
    
    public function get text():String{
        return _text;
    }
    public function set text(str:String):void{
        _text = str;
    }
    
    
    private var selectKeys:Array = new Array();
    public function selectKey(n:int,color:uint=0x00ff00):void{
        var key:Object = this.getChildAt(n);
        key.setColor(color);
        key.setLight(true);
        selectKeys.push(key);
    }
    public function resetKey():void{
        for(var i:int=0;i<selectKeys.length;i++){
            var key:Object = selectKeys[i];
            key.setLight(false);
        }
        while(0<selectKeys.length)selectKeys.pop();
    }



        
    

    
}






















//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////


import flash.display.*;
import flash.text.*;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {

    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var base2:Sprite;
    private var txt:TextField;
    private var label:String = "";
    private var _width:uint = 60;
    private var _height:uint = 20;
    private static var corner:uint = 3;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0xcccccc;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0xdddddd;
    private var gColor:uint = 0x00ff00;
    private var glow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;
    public var lightOn:Boolean = false;
    private var onSelected:Boolean = false;
    private var _isEnter:Boolean;
    //private var isEnterKey:Boolean = false;

    public function Btn(width:Number=20,height:Number=20,isEnter:Boolean=false) {
        _isEnter = isEnter;
        _width = width;
        _height = height;
        draw();
    }

    //ホームポジションのマーカー
    public function setMarker(b:Boolean=true):void{
        base.graphics.clear();
        createBase(base, _width, _height, corner, bColor);//本体
        if(b){
            base.graphics.lineStyle(1,offColor);
            base.graphics.moveTo(_width*0.5-_width*0.2,_height*0.7);
            base.graphics.lineTo(_width*0.5+_width*0.2,_height*0.7);
        }
    }


    private function draw():void {

        glow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        base2 = new Sprite();
        txt = new TextField();
        
        addChild(shade);
        addChild(bottom);
        addChild(base2);
        base2.addChild(light);
        base2.addChild(base);
        base2.addChild(txt);

        
        createBase(shade, _width, _height, corner, sColor);//影
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [glow];
        

        createBase(base, _width, _height, corner, bColor);//本体
        
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        txt.antiAliasType = AntiAliasType.ADVANCED;
        txt.text = label;
        //txt.border = true;
        enabled = true;
        mouseChildren = false;

        txt.width = _width;

        txt.height = _height - 1;
        txt.scaleX = 0.9;
        txt.scaleY = txt.scaleX;
        txt.y = -3;
        base2.graphics.clear();
        //base2.graphics.lineStyle(0,0);
        //base2.graphics.beginFill(0,0);
        base2.graphics.drawRect(0,0,base.width,base.height);
        base2.graphics.endFill();
    }

    public function setColor(c:uint):void{
        gColor = c;
        glow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        light.filters = [glow];
    }


    
    public function get text():String{
        return txt.text;
    }
    public function set text(str:String):void{
        txt.text = str;
    }
    
    public function setLight(s:Boolean):void{
        lightOn = s;
        light.visible = s;
        if(s)txt.textColor = overColor;
        else txt.textColor = upColor;
    }
    
    public function get select():Boolean{
        return lightOn;
    }

    //イベント
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    
    public function _up():void {
        
        if(this.lightOn ==false)txt.textColor = upColor;//テキストカラー
        //base.y = -1;
        if(this.lightOn ==false)light.visible = false;//ライト
        //light.y = -1;
        base2.y = -1;
    }
    private function _over():void {
        txt.textColor = overColor;
        //base.y = -1;
        light.visible = true;
        //light.y = -1;
        base2.y = -1;
    }
    public function _down():void {
        txt.textColor = overColor;
        //base.y = 0;
        light.visible = true;
        //light.y = 0;
        base2.y = 0;
    }
    private function _off():void {
        if(this.lightOn ==false)txt.textColor = offColor;
        //base.y = 0;
        if(this.lightOn ==false)light.visible = false;
        //light.y = 0;
        base2.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    
    public function get enabled():Boolean {
        return _enabled;
    }
    
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        if(_isEnter){//Enter描画用
            target.graphics.drawRect(0,0, w, h*0.45);
            target.graphics.drawRect(w*0.2,h*0.45, w*0.8, h*0.55);
            target.graphics.endFill();
            return;
        }
        target.graphics.drawRect(0,0, w, h);
        target.graphics.endFill();
    }

}



