/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dVKE
 */

package
{
    import flash.events.Event;
    import org.papervision3d.view.*;
    import org.papervision3d.objects.*;
    import Box2D.Dynamics.*;
    import Box2D.Collision.*;
    import Box2D.Common.Math.*;
    import org.papervision3d.lights.PointLight3D;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.parsers.DAE;
    import Box2D.Collision.Shapes.b2CircleDef;
    import Box2D.Common.Math.b2Vec2;
    import org.papervision3d.objects.primitives.Sphere;
    [SWF(backgroundColor="#000000", width="475", height="475")]
    public class Main extends BasicView
    {
        private var world : b2World; 
        public function Main()
        {
            var worldBounds : b2AABB = new b2AABB();
            worldBounds.lowerBound = new b2Vec2(-100, -100);
            worldBounds.upperBound = new b2Vec2(300, 300);
            var gravity : b2Vec2 = new b2Vec2(0, 0);
            world = new b2World(worldBounds, gravity, true);
            for (var i : int = 0; i < 7; i++)
            {
                var bodyDef : b2BodyDef = new b2BodyDef();
                bodyDef.position = new b2Vec2(50, i * 30 + 10);
                var body : b2Body = world.CreateBody(bodyDef);
                var shapeDef : b2CircleDef = new b2CircleDef();
                shapeDef.radius = 15;
                shapeDef.density = 1;
                shapeDef.friction = 0.7;
                shapeDef.restitution = 0.7;
                body.CreateShape(shapeDef);
                body.SetMassFromShapes();
                var sphere : Sphere = new Sphere(null, 30);
                scene.addChild(sphere);
                body.m_userData = sphere;
            }
            var ballshape : b2CircleDef = new b2CircleDef();
            ballshape.radius = 20;
            ballshape.density = 8;
            ballshape.friction = 8;
            ballshape.restitution = 0.9;
            var balldef : b2BodyDef = new b2BodyDef();
            balldef.position.Set(200, 100);
            var ball : b2Body = world.CreateBody(balldef);
            ball.CreateShape(ballshape);
            var pow : b2Vec2 = new b2Vec2(-10, 0);
            ball.SetLinearVelocity(pow); 
            ball.SetMassFromShapes();
            var dae : DAE = new DAE(true, null, true);
            dae.load("http://yumekikaku.dip.jp/obj/miku_run.dae");
            dae.y = -10;
            dae.z = 20;
            dae.scale = 70;
            //dae.rotationY = 90;
            scene.addChild(dae);
            ball.m_userData = dae;
            camera.x = -400;
            camera.y = 50;
            camera.z = -200; 
            startRendering();
            dae.play();
        } 
        override protected function onRenderTick(event : Event = null) : void
        {
            var iterations : int = 10;
            var timeStep : Number = 1.0 / 30.0; 
            world.Step(timeStep, iterations);
            for (var bb : b2Body = world.m_bodyList; bb; bb = bb.m_next)
            {
                if (bb.m_userData is DisplayObject3D)
                {
                    bb.m_userData.x = bb.GetPosition().x * 2 - 475 * .5;
                    bb.m_userData.z = -bb.GetPosition().y * 2 + 475 * .5;
                    bb.m_userData.rotationY = -bb.GetAngle() * (180 / Math.PI) + 90;
                }
            }
            renderer.renderScene(scene, camera, viewport);
        }
    }
}
