/**
 * Copyright dizgid ( http://wonderfl.net/user/dizgid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dVF4
 */

package {
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.TextField;
	import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.*;
    
    [SWF(backgroundColor="#FFFFFF", frameRate=24)]
    public class FlashTest extends Sprite {
    	
       private var nX:Number;
		private var nY:Number;
    		private var nDeceleration:Number;
		private var view:Vector3D;   // 視線のベクトル
		private var origin:Vector3D;   // 原点のベクトル
		private var my_mc:Sprite;
		private var _debugTxt:TextField;
		
		private var _camVec:Vector3D = new Vector3D(0,0,480);
		
		private var _planePos:Vector3D = new Vector3D(200,200,600);
		
        public function FlashTest() {
            // write as3 code here..
            var size:Number = 200;
            my_mc = new Sprite();
            var g:Graphics = my_mc.graphics;
            g.beginFill(0xff0000);
            g.drawRect(-size/2, -size/2, size, size);
            g.endFill();
            
            var txt:TextField = new TextField();
            txt.defaultTextFormat = new TextFormat(null, 90);
            txt.autoSize = TextFieldAutoSize.LEFT;
            txt.text = "ABC";
            txt.x = -txt.width / 2;
            txt.y = -txt.height / 2;
            my_mc.addChild(txt);
            
            my_mc.x = 250 + _planePos.x;
            my_mc.y = 250 + _planePos.y;
            my_mc.z = _planePos.z;

            nX = my_mc.x;
		nY = my_mc.y;
    		nDeceleration = 0.1;
		view = new Vector3D(0,0,1);   // 視線のベクトル
		origin = new Vector3D(nX,nY,0);   // 原点のベクトル

			//my_mc.z = -50;
			
			_debugTxt = new TextField();
			_debugTxt.width = 300;
			this.addChild(_debugTxt);
			
			this.addChild(my_mc);
			addEventListener(Event.ENTER_FRAME, xRotate);
        }
	    private function xRotate(eventObject:Event):void {
	    
		  var nRotationY:Number = (mouseX - nX)*nDeceleration;
		  var nRotationX:Number = (mouseY - nY)*nDeceleration;
		  my_mc.rotationX += 1.0;
		  my_mc.rotationZ += 1.0;
		  
		  var ftontVec:Vector3D = my_mc.transform.matrix3D.deltaTransformVector(new Vector3D(0, 0, 1));
		 var tVec:Vector3D = _camVec.add(_planePos);
		 
		 _debugTxt.text = "";
		 _debugTxt.appendText(String(_camVec) + "\n");
		 _debugTxt.appendText(String(ftontVec) + "\n");
		 _debugTxt.appendText(String(tVec));
		   
		  var nDotProduct:Number = tVec.dotProduct(ftontVec);
		  if (nDotProduct < 0) {
		 //if (ftontVec.z > 0) {
		    my_mc.alpha = 0.5;
		  } else {
		    my_mc.alpha = 1;
		  }
		 
		/*
		  var nRotationY:Number = (mouseX - nX)*nDeceleration;
		  var nRotationX:Number = (mouseY - nY)*nDeceleration;
		  //my_mc.transform.matrix3D.appendTranslation(-nX, -nY, 0);
		  my_mc.transform.matrix3D.appendRotation(nRotationY, Vector3D.Y_AXIS);
		 // my_mc.transform.matrix3D.appendTranslation(nX, nY, 0);
		  var myPosition:Vector3D = my_mc.transform.matrix3D.position;
		  var vector:Vector3D = myPosition.subtract(origin);
		  
		  _debugTxt.text = String(vector);
		  var nDotProduct:Number = view.dotProduct(vector);
		  if (nDotProduct > 0) {
		    my_mc.alpha = 0.5;
		  } else {
		    my_mc.alpha = 1;
		  }
		*/
		} 
    }
}