/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dV1P
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    /**
     * 二点を結ぶ線と囲む四角形を描画します。
     * @author umhr
     */
    public class Main extends Sprite 
    {
        private var _drawCanvas:Sprite = new Sprite();
        public function Main() 
        {
            init();
        }
        private function init():void 
        {
            if (stage) onInit();
            else addEventListener(Event.ADDED_TO_STAGE, onInit);
        }
        
        private function onInit(event:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            var eventCanvas:Sprite = new Sprite();
            eventCanvas.graphics.beginFill(0x000000);
            eventCanvas.graphics.drawRect(0, 0, 465, 465);
            eventCanvas.graphics.endFill();
            eventCanvas.addEventListener(MouseEvent.CLICK, onClick);
            this.addChild(eventCanvas);
            
            this.addChild(_drawCanvas);
            
            onClick(null);
            
            //var aPoint:Point = new Point(50, 300);
            //var bPoint:Point = new Point(300, 30);
            //draw(aPoint,bPoint);
        }
        
        private function onClick(e:MouseEvent):void 
        {
            //trace("onClick");
            var aPoint:Point = new Point(465*Math.random(), 465*Math.random());
            var bPoint:Point = new Point(465*Math.random(), 465*Math.random());
            draw(aPoint,bPoint);
        }
        
        private function draw(aPoint:Point, bPoint:Point):void {
            
            var aSubtract:Point = aPoint.subtract(bPoint);
            aSubtract.normalize(4);
            var a0Point:Point = new Point( -aSubtract.y, aSubtract.x);
            var a1Point:Point = new Point( aSubtract.y, -aSubtract.x);
            
            var bSubtract:Point = bPoint.subtract(aPoint);
            bSubtract.normalize(2);
            var b0Point:Point = new Point( -bSubtract.y, bSubtract.x);
            var b1Point:Point = new Point( bSubtract.y, -bSubtract.x);
            
            a0Point = a0Point.add(aPoint);
            a1Point = a1Point.add(aPoint);
            b0Point = b0Point.add(bPoint);
            b1Point = b1Point.add(bPoint);
            
            _drawCanvas.graphics.clear();
            _drawCanvas.graphics.lineStyle(0, 0x00FF00, 0.5);
            _drawCanvas.graphics.beginFill(0x00FF00, 0.2);
            _drawCanvas.graphics.moveTo(a0Point.x, a0Point.y);
            _drawCanvas.graphics.lineTo(a1Point.x, a1Point.y);
            _drawCanvas.graphics.lineTo(b0Point.x, b0Point.y);
            _drawCanvas.graphics.lineTo(b1Point.x, b1Point.y);
            _drawCanvas.graphics.endFill();
            
            //lineTo
            _drawCanvas.graphics.lineStyle(0, 0xFF0000, 1);
            _drawCanvas.graphics.moveTo(aPoint.x, aPoint.y);
            _drawCanvas.graphics.lineTo(bPoint.x, bPoint.y);
            _drawCanvas.graphics.endFill();
        }
        
    }
    
}