/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dUvX
 */

package {
  import flash.display.*;
  import flash.events.*;
  import flash.geom.Matrix;
  import flash.net.*;
  public class ch30ex4 extends Sprite {
    protected var fileRef:FileReference;
    public function ch30ex4() {
      //CLICK THE STAGE!
      fileRef = new FileReference();
      fileRef.addEventListener(Event.SELECT, onFileSelect);
      stage.addEventListener(MouseEvent.CLICK, onChooseFile);
    }
    protected function onChooseFile(event:MouseEvent):void {
      fileRef.browse([new FileFilter("Image Files", "*.png;*.jpg;*.gif")]);
    }
    protected function onFileSelect(event:Event):void {
      fileRef.removeEventListener(Event.SELECT, onFileSelect);
      stage.removeEventListener(MouseEvent.CLICK, onChooseFile);
      
      fileRef.addEventListener(Event.COMPLETE, onFileLoad);
      fileRef.load();
    }
    protected function onFileLoad(event:Event):void {
      fileRef.removeEventListener(Event.COMPLETE, onFileLoad);
      
      //interpret the bytes into a DisplayObject
      var image:Loader = new Loader();
      image.loadBytes(fileRef.data);
      image.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageParse);
    }
    protected function onImageParse(event:Event):void {
      //get the (uncompressed) bitmap that decoding the file results in
      var content:DisplayObject = LoaderInfo(event.target).content;
      var bitmapData:BitmapData = Bitmap(content).bitmapData;
      var m:Matrix = new Matrix();
      m.identity();
      m.scale(0.25, 0.25);
      graphics.clear();
      graphics.beginBitmapFill(bitmapData, m, true, true);
      graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
    }
  }
}


