/**
 * Copyright akkey.guitar ( http://wonderfl.net/user/akkey.guitar )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dUsg
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import fl.controls.RadioButton;
    import fl.controls.RadioButtonGroup;

    import fl.controls.*;
 
    [SWF(width="500", height="400")]
    public class Main extends Sprite
    {
        private var color:Array = [0xFEBF05, 0xFFD65D];
        private var start:Point = new Point();
        private var canvas:Sprite = new Sprite();
        private var drag:Sprite = new Sprite();
 
        private var parentWidth:Number;
        private var parentHeight:Number;
 
        public function Main(){    
            init();
        }
 
        public function init():void
        {
            //Wonderfl.capture_delay(15);
            //親MCの大きさを定義
            parentWidth = stage.stageWidth;
            parentHeight = stage.stageHeight;
 
            //グラデーションの描画対象を定義
            canvas.graphics.beginFill(0xFFFFFF);
            canvas.graphics.drawRect(0, 0, parentWidth, parentHeight);
            canvas.graphics.endFill();
            addChild(canvas);
 
            //グラデーションを描画する際に使用する位置、角度情報を取得するドラッグオブジェクトの定義
            drag = new Sprite();
            addChild(drag);
 
            //色を決定するカラーパネル（ラジオボタン）
            var ColorPanel:MovieClip = new MovieClip();
            var shape:Shape = new Shape();
            shape.graphics.lineStyle(1, 0xCCCCCC);
            shape.graphics.beginFill(0xE1E1E1);
            shape.graphics.drawRect(0,0,150,200);
            shape.alpha = 0.5;
            ColorPanel.addChild(shape);
 
 
            //カラーパネルの描画位置
            ColorPanel.x = parentWidth - ColorPanel.width;
            ColorPanel.y = parentHeight - ColorPanel.height;
            addChild(ColorPanel);
 
 
            //選択色 配列
            var colorNames:Array = new Array("Yellow", "Blue", "Red", "Green", "Pear");
            var colorArr:Array = new Array([0xFEBF05, 0xFFD65D], [0x80E0F8, 0xCDF8FF], [0x6D0019, 0xA80329], [0x7DE31F, 0xC7FE30], [0xD1D360, 0xE5E695]);
            var radioButton:RadioButton;
            var radioGroup:RadioButtonGroup = new RadioButtonGroup("Colors");
 
            for(var i:int=0; i<colorArr.length; i++){
                radioButton = new RadioButton();
                radioButton.group = radioGroup;
                radioButton.label = colorNames[i];
                radioButton.value = colorArr[i];
                ColorPanel.addChild(radioButton);
                radioButton.x = 5;
                radioButton.y = i * radioButton.height + 70;
                radioButton.addEventListener(MouseEvent.CLICK, _SelectEvent);
                if(i==0) radioButton.selected = true;
            }
 
            stage.addEventListener(MouseEvent.MOUSE_DOWN, _onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, _onMouseUp);
        }
 
        //選択されたラジオボタン
        private function _SelectEvent(event:Event):void
        {
            color = event.currentTarget.value;
        }
 
        //グラデーションの幅と角度の確定　----------------------------------------------------
        private function _onMouseDown(event:MouseEvent):void
        {
            start.x = mouseX;
            start.y = mouseY;
 
            drag.graphics.clear();
            drag.graphics.lineStyle(1.0, 0x7F7F7F);
            drag.graphics.beginFill(0xFFFFFF);
            drag.graphics.drawCircle(start.x, start.y, 3);
            drag.graphics.endFill();
 
            stage.addEventListener(MouseEvent.MOUSE_MOVE, _onMouseMove);
        }
 
        //---------------------------------------------------------------------------------
        private function _onMouseMove(event:MouseEvent):void
        {
            drag.graphics.clear();
 
            drag.graphics.lineStyle(1.0, 0x9F9F9F);
            drag.graphics.moveTo(start.x, start.y);
            drag.graphics.lineTo(mouseX, mouseY);
 
            drag.graphics.lineStyle(1.0, 0x7F7F7F);
            drag.graphics.beginFill(0x333333);
            drag.graphics.drawCircle(start.x, start.y, 3);
            drag.graphics.drawCircle(mouseX, mouseY, 3);
            drag.graphics.endFill();
        }
 
        //---------------------------------------------------------------------------------
        private function _onMouseUp(event:MouseEvent):void
        {
                drag.graphics.clear();
                stage.removeEventListener(MouseEvent.MOUSE_MOVE, _onMouseMove);
 
                var dist:Number = Math.sqrt(Math.pow(mouseX - start.x, 2) + Math.pow(mouseY - start.y, 2));
                var radian:Number = Math.atan2(mouseY - start.y, mouseX - start.x);
 
                var matrix:Matrix = new Matrix();
                matrix.createGradientBox(parentWidth, parentHeight, 0, -parentWidth/2, -parentHeight/2);
 
                canvas.graphics.clear();
                canvas.graphics.beginGradientFill("linear", color, [1.0, 1.0], [127, 128 + dist / 1400 * 255], matrix);
                canvas.graphics.drawRect(-700, -700, parentWidth * 3, parentHeight * 3);
                canvas.graphics.endFill();
                canvas.x = start.x;
                canvas.y = start.y;
                canvas.rotation = radian / (Math.PI / 180);                
                //trace(color + "\n" + 128 + dist/parentWidth * 255 + "\n" + matrix + "\n" );
        }
    }
}