/**
 * Copyright folbore ( http://wonderfl.net/user/folbore )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dUhJ
 */

//歯車創成
package {
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    import flash.text.*;
    
    public class Makegear extends Sprite {
        public var lac_s : Sprite = new Sprite();
        public var gear_s : Sprite = new Sprite();
        public var gear_b : Bitmap;
        public var gear_bd : BitmapData;
        public var base : Sprite = new Sprite();
        public var lacx : Number , lacy : Number;
        public var flm : Number;
        public var tf_b : Sprite = new Sprite();
        public var tf : TextField = new TextField();
        public var sw : Boolean = false;
        
        public var scl : Number = 1; //表示倍率
        public var lcty : Number = 0; //Y方向表示位置
        
        //動作の初期設定
        public var flp : Number = 30; //フレームレート
        public var spd : Number = 0.5*Math.PI/180; //回転角度rad（360度ぴったりにすること）
        public var spdr : Number = 1 * scl; //送り
        public var d_base : Number = 377.42 * scl; //開始位置径

        //ギヤの初期設定
        public var da : Number = 429 * scl; //歯先円直径
        public var dp : Number = 372.42 * scl; //ピッチ円直径＋転移量
        public var zw : Number = 18; //歯数
        
        //ラックの初期設定

        public var p : Number = dp * Math.PI / zw; //基準ピッチ
        public function Makegear() : void {
            stage.frameRate=flp;

            lac_s = drawlac();
            base.x = stage.stageWidth / 2;
            base.y = -d_base / 2 + stage.stageHeight / 2 + lcty;
            base.addChild(lac_s);
            stage.addChild(base);
            
            gear_s = drawgear();
            gear_s.x = stage.stageWidth / 2;
            gear_s.y = stage.stageHeight / 2 + lcty;
            stage.addChild(gear_s);
            
            gear_bd = new BitmapData(stage.stageWidth, stage.stageHeight);
            gear_b = new Bitmap(gear_bd);
            stage.addChild(gear_b);

            gear_bd.draw(stage); 
            stage.removeChild(gear_s);

            stage.addChild(tf_b);
            stage.addChild(tf);

            flm = 0;
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        public function enterFrameHandler(e:Event) : void {
            var r : Number = spd * flm;
            var cnt : Number = Math.floor(r/(Math.PI*2/zw));
            
            lac_s.x = -dp*(r-Math.PI*2/zw*cnt)/2; //+13.83*scl*(2); //シフト量
            base.rotation += spd*180/Math.PI;
            base.x = d_base / 2 * Math.sin(r) + stage.stageWidth / 2;
            base.y = d_base / 2 * (-Math.cos(r)) + stage.stageHeight / 2 + lcty;
            gear_bd.draw(stage); 
            
            tf_b.graphics.beginFill(0xFFFFFF);
            tf_b.graphics.drawRect(0,0,100,20);
            tf_b.graphics.endFill();
            tf.text = lac_s.y.toString();
            
            if (r % (Math.PI*2) == 0) {
                if (sw == false) lac_s.y += spdr;
                if (lac_s.y >= ((d_base-dp)/2) && sw == false) sw = true;
            }
            //if (flm==0) removeEventListener(Event.ENTER_FRAME,arguments.callee); //フレーム1でストップ
            if (sw == true) {
                removeEventListener(Event.ENTER_FRAME,arguments.callee);
                tf.text = "創成完了";
            }

            flm++;
        }

        //ラックを描く
        public function drawlac() :Sprite {
            var lac_s1 : Sprite = new Sprite();
            var lac_s2 : Sprite = new Sprite();
            var ha : Number; //ワーク歯末のたけ
            var hf : Number; //ワーク歯元のたけ()
            var a : Number; //圧力角
            var i : int , zl : Number;     
            
            //ラック設定
            ha = 30.79 * scl;
            hf = 23.615 * scl;
            a = 19.182; //度
            zl = 7; //歯数
            
            

            //描画
            lacx = -p/2*zl;
            lacy = 15 * scl;
            a=a/180*Math.PI;
            
            lac_s1.graphics.beginFill(0xFFFFFF) //ラック白色
            //lac_s1.graphics.beginFill(0x0000FF) //ラック青色
            lac_s1.graphics.lineTo(hf*Math.tan(a)+lacx,0);
            for (i=0 ; i<zl ; i++) {
                lac_s1.graphics.lineTo(hf*Math.tan(a)+p*i+lacx,lacy);
                lac_s1.graphics.lineTo(p/2-hf*Math.tan(a)+p*i+lacx,lacy);
                lac_s1.graphics.lineTo(p/2+ha*Math.tan(a)+p*i+lacx,ha+hf+lacy);
                /*if (i==2||i==3||i==4) {
                    lac_s1.graphics.lineTo(p-ha*Math.tan(a)+p*i+lacx-5*scl,ha+hf+lacy); //欠け初め
                    lac_s1.graphics.lineTo((hf-20*scl)*Math.tan(a)+p*(i+1)+lacx-5*scl,lacy+20*scl);
                    lac_s1.graphics.lineTo((hf-20*scl)*Math.tan(a)+p*(i+1)+lacx-2*scl,lacy+20*scl);
                    lac_s1.graphics.lineTo((hf-10*scl)*Math.tan(a)+p*(i+1)+lacx-2*scl,lacy+10*scl);
                    lac_s1.graphics.lineTo((hf-10*scl)*Math.tan(a)+p*(i+1)+lacx,lacy+10*scl); //欠け終わり
                }else{*/
                    lac_s1.graphics.lineTo(p-ha*Math.tan(a)+p*i+lacx,ha+hf+lacy);
                //}

            }
            lac_s1.graphics.lineTo(p+ha*Math.tan(a)+p*(i-1)+lacx,lacy);
            lac_s1.graphics.lineTo(p+ha*Math.tan(a)+p*(i-1)+lacx,0);
            lac_s1.graphics.endFill();
            lac_s2.addChild(lac_s1);
            lac_s1.y = -lacy-hf;
            return lac_s2;
        }

        //ギヤを描く
        public function drawgear() :Sprite {
            var gear_s1 : Sprite = new Sprite();
            
            //描画
            gear_s1.graphics.beginFill(0xFF0000);
            gear_s1.graphics.drawCircle(0, 0, da/2);
            gear_s1.graphics.endFill();
            return gear_s1;
        }
    }
}