/**
 * Copyright ultranoir ( http://wonderfl.net/user/ultranoir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dUgJ
 */

// forked from alumican_net's [BetweenAS3 Sample] OnXxxEvents
/**
 * onComplete, onPlay, onStop, onUpdate
 * の呼び出しタイミングを検証します
 * 
 * addEventListener(TweenEvwnt.XXX, f);
 * の場合もおそらく同じです
 * 
 * ちなみに、
 * onPlayParams     に指定したデータが onPlay     の実行関数の引数として、
 * onStopParams     に指定したデータが onStop     の実行関数の引数として、
 * onUpdateParams   に指定したデータが onUpdate   の実行関数の引数として、
 * onCompleteParams に指定したデータが onComplete の実行関数の引数として、
 * それぞれ渡されます
 * 
 * 例)
 * tween.onCompleteParams = ["hoge", 123];
 * tween.onComplete = function(s:String, n:int):void
 * {
 *     trace(s, n); //hoge, 123 と表示される
 * }
 */
package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import com.bit101.components.*;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.events.TweenEvent;
	
	public class OnXxxEvents extends Sprite
	{
		private var _t:ITween;
		
		private var _slider:HUISlider;
		
		public function OnXxxEvents():void
		{
			Logger.initialize(this, 0, 0, 465, 435);
			
			var box:Sprite = Box.create(this, 240, 150);
			
			_t = BetweenAS3.tween(box, { x:440 } );
			
			_t.onPlay     = function(...onPlayParams    ):void { Logger.trace("onPlay");                         };
			_t.onStop     = function(...onStopParams    ):void { Logger.trace("      onStop");                   };
			_t.onUpdate   = function(...onUpdateParams  ):void { Logger.trace("            onUpdate");           };
			_t.onComplete = function(...onCompleteParams):void { Logger.trace("                    onComplete"); };
			
			//ui
			new PushButton(this, 240, 320, "play()", _play);
			new PushButton(this, 350, 320, "stop()", _stop);
			new PushButton(this, 240, 350, "gotoAndPlay(0.3)", _gotoAndPlay1);
			new PushButton(this, 350, 350, "gotoAndStop(0.3)", _gotoAndStop1);
			new PushButton(this, 240, 380, "gotoAndPlay(0.6)", _gotoAndPlay2);
			new PushButton(this, 350, 380, "gotoAndStop(0.6)", _gotoAndStop2);
			new PushButton(this, 240, 410, "togglePause()", _togglePause);
			( new CheckBox(this, 350, 415, "stopOnComplete", _stopOnComplete) ).selected = _t.stopOnComplete = false;
			_slider = new HUISlider(this, 10, 440, "position", _position);
			_slider.width   = 465;
			_slider.maximum = _t.duration;
			_t.addEventListener(TweenEvent.UPDATE, function():void { _slider.value = _t.position; } );
		}
		
		private function _play(e:MouseEvent):void
		{
			_t.play();
		}
		
		private function _stop(e:MouseEvent):void
		{
			_t.stop();
		}
		
		private function _togglePause(e:MouseEvent):void
		{
			_t.togglePause();
		}
		
		private function _gotoAndPlay1(e:MouseEvent):void
		{
			_t.gotoAndPlay(0.3);
		}
		
		private function _gotoAndStop1(e:MouseEvent):void
		{
			_t.gotoAndStop(0.3);
		}
		
		private function _gotoAndPlay2(e:MouseEvent):void
		{
			_t.gotoAndPlay(0.6);
		}
		
		private function _gotoAndStop2(e:MouseEvent):void
		{
			_t.gotoAndStop(0.6);
		}
		
		private function _stopOnComplete(e:MouseEvent):void
		{
			_t.stopOnComplete = !_t.stopOnComplete;
		}
		
		private function _position(e:Event):void
		{
			_t.gotoAndStop(_slider.value);
		}
	}
}

import flash.display.*;
import flash.text.*;

/**
 * Tweenターゲットの生成
 */
internal class Box
{
	static public function create(base:DisplayObjectContainer, x:Number, y:Number, color:uint = 0x000000):Sprite
	{
		var o:Sprite = base.addChild( new Sprite() ) as Sprite;
		o.x = x;
		o.y = y;
		var g:Graphics = o.graphics;
		g.beginFill(color);
		g.drawRect(-10, -10, 20, 20);
		g.endFill();
		return o;
	}
}

/**
 * ログ出力
 */
internal class Logger
{
	static private var _field:TextField;
	static private var _index:uint;
	
	static public function initialize(base:DisplayObjectContainer, x:Number = 0, y:Number = 0, width:Number = 465, height:Number = 465):void
	{
		_field                   = new TextField();
		_field.x                 = x;
		_field.y                 = y;
		_field.width             = width;
		_field.height            = height;
		_field.selectable        = false;
		_field.defaultTextFormat = new TextFormat("MS GOTHIC");
		
		_index = 0;
		
		base.addChild(_field);
	}
	
	static public function trace(...m):void
	{
		_field.text = ("    " + String(_index++)).substr(-5, 5) + "  " + m.join(", ") + "\n" + _field.text;
	}
	
	static public function clear(...m):void
	{
		_field.text = "";
		_index = 0;
	}
}