/**
 * Copyright l.dijkman ( http://wonderfl.net/user/l.dijkman )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dUg7
 */

// Free Machinist Bolt Circle calculator circular flange bore
//
// would like to add an input field where user can enter measurement
// and the divide that by Math.sin((360/(NumHoles*2))*Math.PI/180) 
// to calculate circle
// my tabellenboek / machinist handbook says 
// boredistance = circlediameter * sin(360 / (2 * numberofholes))
//
// how do i clear old text? = solved by http://wonderfl.net/user/zahir
// http://wonderfl.net/c/ttvx
//
// forked from tkinjo's Star Class
// http://www.luberth.com/plotter/ditwasplotter.htm
//
// WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!
// if you do a websearch on Google for
// Bolt Pattern Calculator, Common Wheel Bolt Hole Patterns 
// Measure Wheel Pattern, Wheel Bolt Circle Dimensions 
// Wheel Bolt Pattern, Flange Bolts Dimensions
// Calculating Bolt Hole Patterns
// a lot of shit fake virus html webpages come as result
// infeecting your pc with annoying fake messages
// fake virus warnings 
// why is noone doing anything about this 
// lock them up, take their money wich they stole from you
//WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!
// if you have a car wheel with 5 holes how to know and measure the borecircle????
//
// i want to draw holes on circle
// to solve proble i have a car wheel with 5 holes
// thus cannot measure the bolt circle pattern  diameter
// when i measure the hole diameter and the distance from hole to hole
// the distance from star poit to star point + hole diameter
//
// help me????
//
// bore circle pattern solve
// you can not measure bolt-circle diameter on wheels with an odd number of bolt holes
// so want to calculate this

// help???

/*
Measure the Un-Measurable
When It's Not Possible to Measure Across a Bolt Circle
because of Odd Number of Holes
or Hub or Shaft Interference 

Or to check the hole spacing on a known bolt circle
see
http://www.metalwebnews.com/formulas-tables/coordinates.html
http://www.poodwaddle.com/calc3.swf
*/

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Point;
    import flash.text.*;
    
    [SWF(width="500", height="500", backgroundColor="0xffffff", frameRate="60")] 
    /**
     * Star Class
     * 
     * æ˜Ÿã‚¯ãƒ©ã‚¹
     * 
     * ä½¿ã„æ–¹ã¯ createStar ãƒ¡ã‚½ãƒƒãƒ‰ã‚’å‚ç…§
     * 
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        private var stageWidth:Number = stage.stageWidth;
        private var stageHeight:Number = stage.stageHeight;
        private var stageCenter:Point = new Point( stageWidth / 2, stageHeight / 2 );
        
        /** --------------------------------------------------
         * component
         */
        private var configPanel:SlidePanel;
        private var NumHolesInputTextAndHSlider:InputTextAndHSlider;
        private var outerRadiusInputTextAndHSlider:InputTextAndHSlider;
        private var HoleSizeInputTextAndHSlider:InputTextAndHSlider;
        
        private var canvas:Sprite;
        private var star:Star;
        
        public function Main() 
        {
            canvas = new Sprite();
            addChild( canvas );
            
            createComponent();
            
            createStar();
        }
        
        private function createStar():void {
            
            var starStroke:GraphicsStroke = new GraphicsStroke( 1 );
            starStroke.fill = new GraphicsSolidFill();
            
            star = new Star( NumHolesInputTextAndHSlider.value, outerRadiusInputTextAndHSlider.value, HoleSizeInputTextAndHSlider.value, null, starStroke );
            star.x = stageCenter.x;
            star.y = stageCenter.y;
            
            canvas.addChild( star );
        }
        
        
        
        
        
        private function createComponent():void {
            
            configPanel = new SlidePanel( 0, 0, stageWidth, 0, 1, 0xffffff, 0.9 );
            addChild( configPanel );
            
            // NumHolesInputTextAndHSlider
            NumHolesInputTextAndHSlider = createInputTextAndHSlider( "num Holes" );
            NumHolesInputTextAndHSlider.round = 5;
            NumHolesInputTextAndHSlider.hSlider.minimum = 1;
            NumHolesInputTextAndHSlider.hSlider.maximum = 32;
            NumHolesInputTextAndHSlider.value = 5;
            NumHolesInputTextAndHSlider.addEventListener(Event.CHANGE, function( event:Event ):void {
                    star.NumHoles = NumHolesInputTextAndHSlider.value;
                } );
            
            // outerRadiusInputTextAndHSlider
            outerRadiusInputTextAndHSlider = createInputTextAndHSlider( "outerRadius", NumHolesInputTextAndHSlider );
            outerRadiusInputTextAndHSlider.round = 0.01;
            outerRadiusInputTextAndHSlider.hSlider.maximum = 300.00;
            outerRadiusInputTextAndHSlider.value = 200.00;
            outerRadiusInputTextAndHSlider.addEventListener(Event.CHANGE, function( event:Event ):void {
                    star.outerRadius = outerRadiusInputTextAndHSlider.value;
                } );
            
             HoleSizeInputTextAndHSlider
            HoleSizeInputTextAndHSlider = createInputTextAndHSlider( "Hole Diam", outerRadiusInputTextAndHSlider );
            HoleSizeInputTextAndHSlider.round = 0;
            HoleSizeInputTextAndHSlider.hSlider.maximum = 100;
            HoleSizeInputTextAndHSlider.value = 18;
            HoleSizeInputTextAndHSlider.addEventListener(Event.CHANGE, function( event:Event ):void {
                star.HoleSize = HoleSizeInputTextAndHSlider.value;
              } );
            
            configPanel.height = HoleSizeInputTextAndHSlider.y + HoleSizeInputTextAndHSlider.height;
        }
        
        private function createInputTextAndHSlider( text:String = "", component:DisplayObject = null ):InputTextAndHSlider {
            
            var inputTextAndHSlider:InputTextAndHSlider = new InputTextAndHSlider( configPanel, 10, ( component != null ) ? component.y + component.height + 1 : 1, text );
            inputTextAndHSlider.label.width     = 70;
            inputTextAndHSlider.inputText.width = 30;
            inputTextAndHSlider.hSlider.width   = 300;
            
            return inputTextAndHSlider;
        }
    }
}



import com.bit101.components.*;
import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.Cubic;

class Star extends Sprite {
    
    /**
     * 
     */
    public function get NumHoles():uint { return _NumHoles; }
    public function set NumHoles(value:uint):void 
    {
        _NumHoles = value;
        draw();
    }
    private var _NumHoles:uint;
    
    
    /**
     * 
     */
    public function get outerRadius():Number { return _outerRadius; }
    public function set outerRadius(value:Number):void 
    {
        _outerRadius = value;
        draw();
    }
    private var _outerRadius:Number;
    
    
    
    /**
     * 
     */
    public function get HoleSize():Number { return _HoleSize; }
    public function set HoleSize(value:Number):void 
    {
        _HoleSize = value;
        draw();
    }
    private var _HoleSize:Number;
    
    
    
    /**
     * 
     */
    public function get fill():IGraphicsData { return _fill; }
    public function set fill(value:IGraphicsData):void 
    {
        _fill = value;
        draw();
    }
    private var _fill:IGraphicsData;
    
    
    
    /**
     * 
     */
    public function get stroke():IGraphicsData { return _stroke; }
    public function set stroke(value:IGraphicsData):void 
    {
        _stroke = value;
        draw();
    }
    private var _stroke:IGraphicsData;
    
    
    
    /**
     * 
     */
    public function Star( NumHoles:uint, outerRadius:Number, HoleSize:Number, fill:IGraphicsData = null, stroke:IGraphicsData = null ):void {
        
        _NumHoles   = NumHoles;
        _outerRadius = outerRadius;
        _HoleSize = HoleSize;
        _fill        = fill;
        _stroke      = stroke;
        
        draw();
    }
    
 public function DrawText(x:Number
                                ,y:Number
                                ,z:String
                               ,position:uint):TextField{
     
            var tx:TextField = new TextField();
           
            //tx.visible=0;
            tx.text=z;
            //tx.visible=1;
            
            switch(position%3){
                case 1:
                    tx.autoSize="left";
                    tx.x=x;
                    break;
                case 2:
                    tx.autoSize="center";
                    tx.x=x-tx.textWidth/2;
                    break;
                case 0:
                    tx.autoSize="right";
                    tx.x=x-tx.textWidth;
                    break;
                default:
                    break;
            }
            switch(int((position-1)/3)){
                case 0:
                    tx.y=y;
                    break;
                case 1:
                    tx.y=y-tx.textHeight/2;
                    break;
                case 2:
                    tx.y=y-tx.textHeight;
                    break;
                default:
                    break;
            }
            addChild(tx);

            return tx;
        }    
    
    
    
    
    
    
    private function draw():void {
            
       // ALL removeChildren = clear old text
       while( numChildren ) removeChildAt( 0 );   
        graphics.clear();
        
        
        var drawGraphicsData:Vector.<IGraphicsData> = Vector.<IGraphicsData>([ fill, stroke ]);
        
       
        
        // path
        var exteriorAngle:Number = Math.PI * 2 / NumHoles;
        
        var pathData:Vector.<Point> = new Vector.<Point>();
        
        //for ( var i:uint = 0; i < NumHoles; i++ ) {
            
            //pathData.push( new Point( Math.sin( exteriorAngle * i  ) * outerRadius, 0 + Math.cos( exteriorAngle * i  ) * outerRadius ) );
           // pathData.push( new Point( Math.sin( exteriorAngle * i ) * HoleSize, Math.cos( exteriorAngle * i ) * HoleSize ) );
        //}
        
        //var path:GraphicsPath = createGraphicsPathAtData( pathData );
        //drawGraphicsData.push( path );
        
        
      
       
         //draw
        graphics.drawGraphicsData( drawGraphicsData );
 for ( var i:uint = 0; i < NumHoles; i++ ) {
       graphics.lineStyle(2, 0xFF0000, 1); 
       graphics.drawCircle(outerRadius*Math.sin( exteriorAngle*i) , outerRadius*Math.cos( exteriorAngle*i) ,HoleSize);
       graphics.lineStyle(1, 0xFF0000, 1);
 
       //just a test to see if .588 is really the boredistance at 5 holes
       if(NumHoles==5){
            graphics.lineStyle(1, 0xcecece, 1);
            graphics.drawCircle(outerRadius*Math.sin( exteriorAngle*i) , outerRadius*Math.cos( exteriorAngle*i),outerRadius*.587785*2);
       }
       if(NumHoles==6){
            graphics.lineStyle(1, 0xcecece, 1);
            graphics.drawCircle(outerRadius*Math.sin( exteriorAngle*i) , outerRadius*Math.cos( exteriorAngle*i),outerRadius);
       }
       if(NumHoles==12){
            graphics.lineStyle(1, 0xeeeeee, 1);
            graphics.drawCircle(outerRadius*Math.sin( exteriorAngle*i) , outerRadius*Math.cos( exteriorAngle*i),outerRadius);
       }
       
       graphics.lineStyle(1, 0xececec, 1);
       graphics.drawCircle(0,0,outerRadius);
 
       graphics.lineStyle(1, 0x00ff00, 1);             
       graphics.moveTo(0 , 0);
       graphics.lineTo(outerRadius*Math.sin( exteriorAngle*i) , outerRadius*Math.cos( exteriorAngle*i));



       DrawText(outerRadius*Math.sin( exteriorAngle*i) , outerRadius*Math.cos( exteriorAngle*i),""+((180-(360/NumHoles))/2+"°"),1);
       graphics.lineTo(outerRadius*Math.sin( exteriorAngle*(i-1)) , outerRadius*Math.cos( exteriorAngle*(i-1)));
       DrawText(0,10,""+360/NumHoles+"°",1);
       
      
 }
    
       graphics.lineStyle(1, 0xFF0000, 1);
       
           if(NumHoles==3){
               DrawText(-100,125,"3 Holes, borecircle=boredistance / 0.866 \n bore distance " + Math.sqrt(3)*outerRadius/2,5);
           }
           if(NumHoles==4){
               DrawText(-100,125,"4 Holes, borecircle=boredistance / 0.707 \n bore distance " + Math.sqrt(2)*outerRadius/2,5);
           }
           if(NumHoles==5){
               DrawText(-100,125,"5 Holes, borecircle=boredistance / 0.588 \nboredistance = "+(outerRadius*0.587785),5); 
           }
           if(NumHoles==6){
               DrawText(-100,125,"6 Holes, borecircle=boredistance / 0.5",5);
           }
           if(NumHoles==8){
               DrawText(-100,125,"8 Holes, borecircle=boredistance / 0.383",5);
           }
           if(NumHoles==10){
               DrawText(-100,125,"10 Holes, borecircle=boredistance / 0.309",5);
           }
           if(NumHoles==12){
               DrawText(-100,125,"12 Holes, borecircle=boredistance / 0.259",5);
           }
           DrawText(-100,155,"Circle  "+outerRadius,5); 
           //DrawText(-100,166, ""+Math.sin(360/NumHoles*2),5);
            //angle*Math.PI/180
   DrawText(-100,215, "Measure hole distance and divide by "+Math.sin((360/(NumHoles*2))*Math.PI/180),1);
    }
    }
function createGraphicsPathAtData( pathData:Vector.<Point> ):GraphicsPath 
{
    var commands:Vector.<int> = new Vector.<int>();
    var data:Vector.<Number> = new Vector.<Number>();
    
    var pathDataLength:int = pathData.length; 
    
    for ( var i:uint = 0; i < pathDataLength; i++ ) {
        
        if( i != 0 )
            commands.push( GraphicsPathCommand.LINE_TO );
        else if( i == 0 )
            commands.push( GraphicsPathCommand.MOVE_TO );
        
        data.push( pathData[i].x, pathData[i].y );
    }
    
    commands.push( GraphicsPathCommand.LINE_TO );
    data.push( pathData[0].x, pathData[0].y );
    
    return new GraphicsPath( commands, data );
}







/* -----
 * component
 *//*
import com.bit101.components.*;
import flash.display.*;
import flash.events.*;
import flash.text.*;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.Cubic;
//*/
class LabelEx extends Label {
    
    /**
     * Dispatched after a control value is modified, unlike the textInput event, which is dispatched before the value is modified.
     * @eventType flash.events.Event.CHANGE
     */
    [Event(name = "change", type = "flash.events.Event")] 
    
    /**
     * ...
     * @eventType com.bit101.components.Component.DRAW
     */
    [Event(name = "draw", type = "com.bit101.components.Component")] 
    
    
    
    //private var textField:TextField;
    
    public function LabelEx(parent:DisplayObjectContainer = null, xpos:Number = 0, ypos:Number =  0, text:String = ""):void
    {
        super(parent, xpos, ypos, text);
    }
    
    /**
     * Initializes the component.
     */
    override protected function init():void
    {
        super.init();
        setSize(100, 16);
    }
    
    /**
     * Creates and adds the child display objects of this component.
     */
    override protected function addChildren():void
    {
        super.addChildren();
        
        for ( var i:uint = 0; i < numChildren; i++ ) {
            
            var child:DisplayObject = getChildAt( i );
            
            if ( child is TextField ) {
                
                // textField = child as TextField;
                break;
            }
        }
    }
}

class InputTextEx extends InputText {
    
    /**
     * Dispatched after a control value is modified, unlike the textInput event, which is dispatched before the value is modified.
     * @eventType flash.events.Event.CHANGE
     */
    [Event(name = "change", type = "flash.events.Event")] 
    
    /**
     * ...
     * @eventType com.bit101.components.Component.DRAW
     */
    [Event(name = "draw", type = "com.bit101.components.Component")] 
    
    //private var textField:TextField;
    
    public function InputTextEx(parent:DisplayObjectContainer = null, xpos:Number = 0, ypos:Number =  0, text:String = "", defaultHandler:Function = null)
    {
        super( parent, xpos, ypos, text, defaultHandler );
    }
    
    /**
     * Creates and adds child display objects.
     */
    override protected function addChildren():void
    {
        super.addChildren();
        
        for ( var i:uint = 0; i < numChildren; i++ ) {
            
            var child:DisplayObject = getChildAt( i );
            
            if ( child is TextField ) {
                
                //TextField = child as TextField;
                break;
            }
        }
        
        textField.autoSize = TextFieldAutoSize.LEFT;
    }
    
    protected override function onChange(event:Event):void
    {
        super.onChange( event );
        dispatchEvent( event );
    }
}

class HSliderEx extends HSlider {
    
    /**
     * Dispatched after a control value is modified, unlike the textInput event, which is dispatched before the value is modified.
     * @eventType flash.events.Event.CHANGE
     */
    [Event(name = "change", type = "flash.events.Event")] 
    
    /**
     * ...
     * @eventType com.bit101.components.Component.DRAW
     */
    [Event(name = "draw", type = "com.bit101.components.Component")] 
    
    public function HSliderEx(parent:DisplayObjectContainer = null, xpos:Number = 0, ypos:Number =  0, defaultHandler:Function = null):void
    {
        super(parent, xpos, ypos, defaultHandler);
    }
}

class InputTextAndHSlider extends Sprite {
    
    /**
     * Dispatched after a control value is modified, unlike the textInput event, which is dispatched before the value is modified.
     * @eventType flash.events.Event.CHANGE
     */
    [Event(name = "change", type = "flash.events.Event")]
    
    
    
    /**
     * label
     */
    public function get label():Label {
        
        return _label;
    }
    private var _label:Label;
    
    
    
    /**
     * inputText
     */
    public function get inputText():InputTextEx {
        
        return _inputText;
    }
    private var _inputText:InputTextEx;
    
    
    
    /**
     * hSlider
     */
    public function get hSlider():HSliderEx {
        
        return _hSlider;
    }
    private var _hSlider:HSliderEx;
    
    
    
    /**
     * round
     */
    public var round:int = 20;
    
    
    
    /**
     * value
     */
    public function get value():Number {
        
        return _value;
    }
    public function set value( tempValue:Number ):void {
        
        hSlider.value = tempValue;
        
        _value = Math.round( hSlider.value * Math.pow( 10, round ) ) / Math.pow( 10, round );
        
        if ( !isNaN( value ) )
            inputText.text = value.toString();
        
        dispatchEvent( new Event( Event.CHANGE ) );
    }
    private var _value:Number;
    
    
    
    /**
     * 
     * @param    parent
     * @param    xpos
     * @param    ypos
     * @param    text
     */
    public function InputTextAndHSlider(parent:DisplayObjectContainer=null, xpos:Number=0, ypos:Number=0, text:String = ""):void
    {
        parent.addChild( this );
        x = xpos;
        y = ypos;
        
        // label
        _label = new LabelEx( this, 0, 0, text );
        
        // inputText
        _inputText = new InputTextEx( this );
        inputText.restrict = "-0-9.";
        updateInputTextPosition( label );
        
        // hSlider
        _hSlider = new HSliderEx( this );
        hSlider.backClick = true;
        updateHSliderPosition( inputText );
        
        
        
        // hSlider eventlistener
        label.addEventListener(Component.DRAW, function( event:Event ):void {
                updateInputTextPosition( label );
            } );
        
        // inputText eventlistener
        inputText.addEventListener(Event.CHANGE, function( event:Event ):void {
                value = parseFloat( inputText.text );
            } );
        inputText.addEventListener(Component.DRAW, function( event:Event ):void {
                updateHSliderPosition( inputText );
            } );
        inputText.addEventListener(FocusEvent.FOCUS_OUT, function( event:FocusEvent ):void {
                if ( isNaN( value ) )
                    inputText.text = "0";
            } );
        
        // hSlider eventlistener
        hSlider.addEventListener(Event.CHANGE, function( event:Event ):void {
                value = hSlider.value;
            } );
    }
    
    
    
    /**
     * 
     * @param    component
     */
    private function updateInputTextPosition( component:DisplayObject ):void {
        
        inputText.y = component.y + ( component.height - inputText.height ) / 2;
        inputText.x = ( component.x + component.width ) + ( inputText.y - component.y );
    }
    
    
    
    /**
     * 
     * @param    component
     */
    private function updateHSliderPosition( component:Component ):void {
        
        hSlider.y = component.y + ( component.height - hSlider.height ) / 2;
        hSlider.x = ( component.x + component.width ) + ( hSlider.y - component.y );
    }
}



class ClearColorPanel extends Sprite {
    
    private var _backgroundColor:Number;
    public function get backgroundColor():Number { return _backgroundColor; }
    public function set backgroundColor(value:Number):void 
    {
        _backgroundColor = value;
        draw();
    }
    
    
    
    private var _backgroundAlpha:Number;
    public function get backgroundAlpha():Number { return _backgroundAlpha; }
    public function set backgroundAlpha(value:Number):void 
    {
        _backgroundAlpha = value;
        draw();
    }
    
    private var _width:Number;
    public override function get width():Number { return _width; }
    public override function set width(value:Number):void 
    {
        _width = value;
        draw();
    }
    
    private var _height:Number;
    public override function get height():Number { return _height; }
    public override function set height(value:Number):void 
    {
        _height = value;
        draw();
    }
    
    
    
    
    
    public function ClearColorPanel( x:Number = 0, y:Number = 0, width:Number = 0, height:Number = 0, alpha:Number = 1, backgroundColor:int = 0, backgroundAlpha:Number = 0.1 ) {
        
        this.x = x;
        this.y = y;
        _width = width;
        _height = height;
        this.alpha = alpha;
        _backgroundColor = backgroundColor;
        _backgroundAlpha = backgroundAlpha;
        
        draw();
    }
    
    public function draw():void {
        
        graphics.clear();
        graphics.beginFill( backgroundColor, backgroundAlpha );
        graphics.drawRect(0, 0, width, height );
        graphics.drawCircle(10,x,y);
        graphics.endFill();
    }
}

class SlidePanel extends Sprite {
    
    private var panel:ClearColorPanel;
    private var openCloseSwitchButton:PushButton;
    private var open:Boolean;
    
    
    public override function set width(value:Number):void 
    {
        super.width = value;
        panel.width = value;
        openCloseSwitchButton.x = width - 20;
    }
    
    public override function set height(value:Number):void 
    {
        super.height = height;
        panel.height = value;
    }
    
    
    public function SlidePanel( x:Number = 0, y:Number = 0, width:Number = 0, height:Number = 0, alpha:Number = 1, backgroundColor:int = 0, backgroundAlpha:Number = 0.1 ) {
        
        this.x = x;
        this.y = y;
        
        panel = new ClearColorPanel( 0, 0, width, height, alpha, backgroundColor, backgroundAlpha );
        super.addChild( panel );
        
        openCloseSwitchButton = new PushButton(super, width - 20, 0);
        super.addChild( openCloseSwitchButton );
        openCloseSwitchButton.width = 20;
        openCloseSwitchButton.addEventListener(MouseEvent.CLICK, openCloseSwitchButtonClickHandler );
        
        openCloseSwitchButton.label = "-";
        open = true;
    }
    
    private function openCloseSwitchButtonClickHandler( event:MouseEvent ):void {
        
        // hide
        if ( open )
            show();
            
        // show
        else
            hide();
    }
    
    private function show():void {
        
        open = false;
        openCloseSwitchButton.label = "+";
        BetweenAS3.tween(panel, {y: -panel.height}, null, 0.5, Cubic.easeInOut ).play();
    }
    
    private function hide():void {
        
        open = true;
        openCloseSwitchButton.label = "-";
        BetweenAS3.tween(panel, { y: 0 }, null, 0.5, Cubic.easeInOut ).play();
    }
    
    
    override public function addChild(child:DisplayObject):DisplayObject 
    {
        return panel.addChild(child);
    }
    
    override public function addChildAt(child:DisplayObject, index:int):DisplayObject 
    {
        return panel.addChildAt(child, index);
    }
    
    
    
    
    
}