/**
 * Copyright Tamotsu.Sennen ( http://wonderfl.net/user/Tamotsu.Sennen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dUff
 */

// forked from umhr's URL、パス、FlashVers、クエリの取得をします。
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.external.ExternalInterface;
    import flash.net.LocalConnection;
    import flash.text.TextField;
    
    /**
     * URL、パス、FlashVers、クエリの取得をします。
     * 参考
     * http://www.project-nya.jp/modules/weblog/details.php?blog_id=1196
     * @author umhr
     */
    public class Main extends Sprite 
    {
        
        public function Main() 
        {
            init();
        }
        private function init():void 
        {
            if (stage) onInit();
            else addEventListener(Event.ADDED_TO_STAGE, onInit);
        }
        
        private function onInit(event:Event = null):void 
        {
            // ※ここが間違っていたのでので修正（init → onInit）
            removeEventListener(Event.ADDED_TO_STAGE, onInit);
            // entry point
            
            //参考
            //http://www.project-nya.jp/modules/weblog/details.php?blog_id=1196
            
            var text:String = "";
            text += "◆SWFファイルのURLを取得する(loaderInfo.url)\n";
            text += stage.loaderInfo.url;
            text += "\n\n";
            text += "◆SWFファイルのURLを取得する(loaderInfo.loaderURL)\n";
            text += stage.loaderInfo.loaderURL;
            text += "\n\n";
            text += "◆ドメインを取得する(new LocalConnection( ).domain)\n";
            text += new LocalConnection( ).domain;
            text += "\n\n";
            text += "◆FlashVarsを取得する(loaderInfo.parameters.flashvars)\n";
            text +=  stage.loaderInfo.parameters.flashvars;
            text += "\n\n";
            text += "◆GETクエリを取得する(loaderInfo.parameters.getquery)\n";
            text += stage.loaderInfo.parameters.getquery;
            text += "\n\n";
            text += '◆SWFファイルが配置されたURLを取得する(ExternalInterface.call("function() { return window.location.href; }"))\n';
            text += getExternalInterfaceCall("href");
            text += "\n\n";
            text += '◆URLクエリを取得する(ExternalInterface.call("function() { return window.location.search; }"))\n';
            text += getExternalInterfaceCall("search");
            
            addText(text);
        }
        
        private function getExternalInterfaceCall(target:String):String {
            var result:String = "";
            try {
                result = ExternalInterface.call("function() { return window.location." + target + "; }");
            } catch (e:*) {
                //trace(e)
                result = e;
            }
            return result;
        }
        
        private function addText(text:String, x:int = 0, y:int = 0):void {
            var textField:TextField = new TextField();
            textField.text = text;
            textField.width = stage.stageWidth;
            textField.height = stage.stageHeight;
            textField.multiline = true;
            textField.wordWrap = true;
            textField.x = x;
            textField.y = y;
            this.addChild(textField);
        }
        
    }
    
}