/**
 * Copyright majoraze ( http://wonderfl.net/user/majoraze )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dUF6
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class Velocity extends Sprite {
        private var ball:Ball;
        private var angle:Number = 45;
        private var speed:Number = 3;
        
        public function Velocity() {
            init();
        }
        
        private function init():void {
            ball = new Ball();
            addChild(ball);
            ball.x = stage.stageWidth/2;
            ball.y = stage.stageHeight/2;
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            var radians:Number = angle * Math.PI/180;
            var vx:Number = Math.cos(radians) * speed;
            var vy:Number = Math.sin(radians) * speed;
            ball.x += vx;
            ball.y += vy;
        }



    }
}


import flash.display.Sprite;

class Ball extends Sprite {
    private var radius:Number;
    private var color:uint;
    
    public function Ball(radius:Number = 40, color:uint = 0xff0000) {
        this.radius = radius;
        this.color = color;
        
        init();
    }
    
    public function init():void {
        graphics.beginFill(color);
        graphics.drawCircle(0,0,radius);
        graphics.endFill()
    }
}