/**
 * Copyright kaikoga ( http://wonderfl.net/user/kaikoga )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dTXd
 */

// forked from tail_y's forked from: [最適化 Tips] Number, int, uint の計算による処理速度の違い
// forked from muta244's [最適化 Tips] Number, int, uint の計算による処理速度の違い

package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    static private const _NUM_TIMES:int = 200000;
    
    private function _emptyFunc():void
    {
        ;
    }
    
    private var i:int = 0;
    private function get _getter():int
    {
        return this.i;
    }
    
    private function _test2():void
    {
        for (var i:uint = 0; i < _NUM_TIMES; i++) {
            var o:int = this._getter;
        }
    }
    
    private function _test3():void
    {
        for (var i:uint = 0; i < _NUM_TIMES; i++) {
            this._emptyFunc();
        }
    }
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        
        _measure("ループのみ", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                
            }
        });
        
        _measure("文字列を捨てるループ", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                "String";
            }
        });
        
        _measure("文字列を代入するループ", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var str:String = "String";
            }
        });
        
        _measure("XMLリテラルを捨てるループ", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                <root />;
            }
        });
        
        _measure("XMLリテラルを代入するループ", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var xml:XML = <root />;
            }
        });
        
        _measure("暗黙のメンバ関数呼び出し", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                _emptyFunc();
            }
        });
        
        _measure("this付きのメンバ関数呼び出し", this._test3);
        
        _measure("暗黙のgetter呼び出し", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = _getter;
            }
        });
        
        _measure("this付きのgetter呼び出し", function ():void
        {
            this._test2();
        });
        
        _measure("直接this付きのgetter呼び出し", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = this._getter;
            }
        });
        
        _measure("apply()経由でthis付きのメンバ関数呼び出し", function ():void
        {
            this._test3()
        });
        
        _measure("apply()経由で直接this付きのメンバ関数呼び出し", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                this._emptyFunc();
            }
        });
        
        _measure("変数に代入したメンバ関数呼び出し", function ():void
        {
            var func:Function = _emptyFunc;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                func();
            }
        });
        
        _measure("匿名関数呼び出し", function ():void
        {
            var func:Function = function():void { ; };
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                func();
            }
        });
        
        _measure("文字列リテラルを捨てる匿名関数呼び出し", function ():void
        {
            var func:Function = function():void { "String" };
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                func();
            }
        });
        
        _measure("文字列リテラルを返す匿名関数呼び出し", function ():void
        {
            var func:Function = function():String { return "String" };
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var str:String = func();
            }
        });
        
        _measure("XMLリテラルを捨てる匿名関数呼び出し", function ():void
        {
            var func:Function = function():void { <hoge /> };
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                func();
            }
        });
        
        _measure("XMLリテラルを返す匿名関数呼び出し", function ():void
        {
            var func:Function = function():XML { return <hoge /> };
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var xml:XML = func();
            }
        });
        
        _measure("入れ子の匿名関数を捨てる呼び出し", function ():void
        {
            var func:Function = function():void { (function():void { ; }) };
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                func();
            }
        });
        
        _measure("入れ子の匿名関数を呼び出す匿名関数呼び出し", function ():void
        {
            var func:Function = function():void { (function():void { ; })() };
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                func();
            }
        });
        
        _debug("\n結果を説明するスペースなんてなかった");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(this, params);
        _time = getTimer() - _time;

        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
