/**
 * Copyright littlepad ( http://wonderfl.net/user/littlepad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dRtm
 */

package {
    import flash.geom.ColorTransform;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private const DOT_WIDTH:uint = 5;
        private const DOT_HEIGHT:uint = 5;
        private const DOT_MARGIN:uint = 1;
        private const CHAR_MARGIN:uint = 10;
        private const DOT_NUM:uint = 11;
        private const DOT_COLOR:uint = 0x000000;
        private const CHARS:Array = [
            [{x:0, y:0}, {x:0, y:1}, {x:0, y:2}, {x:0, y:3}, {x:0, y:4}, {x:0, y:5}, {x:0, y:6}, {x:0, y:7}, {x:0, y:8}, {x:0, y:9}, {x:0, y:10}, {x:1, y:0}, {x:2, y:0}, {x:2, y:2}, {x:2, y:4}, {x:2, y:6}, {x:2, y:7}, {x:2, y:8}, {x:2, y:9}, {x:3, y:0}, {x:3, y:3}, {x:3, y:4}, {x:3, y:5}, {x:3, y:6}, {x:3, y:7}, {x:3, y:8}, {x:3, y:9}, {x:4, y:0}, {x:4, y:2}, {x:4, y:4}, {x:4, y:6}, {x:4, y:7}, {x:4, y:8}, {x:4, y:9}, {x:5, y:0}, {x:5, y:10}, {x:6, y:0}, {x:6, y:1}, {x:6, y:2}, {x:6, y:3}, {x:6, y:4}, {x:6, y:5}, {x:6, y:6}, {x:6, y:7}, {x:6, y:8}, {x:6, y:9}, {x:6, y:10}, {x:8, y:0}, {x:8, y:1}, {x:8, y:2}, {x:8, y:3}, {x:8, y:4}, {x:9, y:10}, {x:10, y:0}, {x:10, y:1}, {x:10, y:2}, {x:10, y:3}, {x:10, y:4}, {x:10, y:5}, {x:10, y:6}, {x:10, y:7}, {x:10, y:8}, {x:10, y:9}, {x:10, y:10}],
            [{x:0, y:2}, {x:0, y:10}, {x:1, y:2}, {x:1, y:10}, {x:2, y:2}, {x:2, y:9}, {x:3, y:2}, {x:3, y:7}, {x:3, y:8}, {x:4, y:2}, {x:4, y:5}, {x:4, y:6}, {x:5, y:0}, {x:5, y:1}, {x:5, y:2}, {x:5, y:3}, {x:5, y:4}, {x:6, y:2}, {x:7, y:2}, {x:8, y:2}, {x:8, y:10}, {x:9, y:2}, {x:9, y:10}, {x:10, y:2}, {x:10, y:3}, {x:10, y:4}, {x:10, y:5}, {x:10, y:6}, {x:10, y:7}, {x:10, y:8}, {x:10, y:9}, {x:10, y:10}],
            [{x:0, y:1}, {x:0, y:2}, {x:0, y:3}, {x:0, y:6}, {x:0, y:9}, {x:0, y:10}, {x:1, y:1}, {x:1, y:6}, {x:1, y:8}, {x:2, y:0}, {x:2, y:2}, {x:2, y:3}, {x:2, y:5}, {x:2, y:6}, {x:2, y:7}, {x:2, y:8}, {x:2, y:9}, {x:2, y:10}, {x:3, y:0}, {x:3, y:4}, {x:3, y:6}, {x:3, y:8}, {x:4, y:0}, {x:4, y:2}, {x:4, y:3}, {x:4, y:6}, {x:4, y:9}, {x:4, y:10}, {x:6, y:2}, {x:6, y:6}, {x:6, y:10}, {x:7, y:2}, {x:7, y:6}, {x:7, y:10}, {x:8, y:1}, {x:8, y:5}, {x:8, y:9}, {x:9, y:0}, {x:9, y:4}, {x:9, y:8}, {x:10, y:0}, {x:10, y:4}, {x:10, y:8}],
            [{x:0, y:1}, {x:0, y:5}, {x:0, y:10}, {x:1, y:1}, {x:1, y:3}, {x:1, y:5}, {x:1, y:10}, {x:2, y:0}, {x:2, y:1}, {x:2, y:2}, {x:2, y:3}, {x:2, y:5}, {x:2, y:9}, {x:3, y:1}, {x:3, y:3}, {x:3, y:5}, {x:3, y:9}, {x:4, y:1}, {x:4, y:3}, {x:4, y:5}, {x:4, y:8}, {x:5, y:1}, {x:5, y:3}, {x:5, y:5}, {x:5, y:8}, {x:6, y:1}, {x:6, y:3}, {x:6, y:5}, {x:6, y:7}, {x:6, y:10}, {x:7, y:1}, {x:7, y:3}, {x:7, y:5}, {x:7, y:6}, {x:7, y:10}, {x:8, y:0}, {x:8, y:1}, {x:8, y:2}, {x:8, y:3}, {x:8, y:4}, {x:8, y:5}, {x:8, y:6}, {x:8, y:7}, {x:8, y:8}, {x:8, y:9}, {x:8, y:10}, {x:9, y:1}, {x:9, y:3}, {x:9, y:5}, {x:10, y:1}, {x:10, y:5}]
        ];
        private var _fixPoints:Array;
        private var _charSize:uint = DOT_WIDTH * DOT_NUM + DOT_MARGIN * (DOT_NUM - 1);
        private var _dots:Array;
        private var _bmd:BitmapData;
        private const SPEED:Number = 5;
        
        public function FlashTest() {
            this.addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
        }
        
        private function addedToStageHandler(event:Event):void
        {
            this.removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
            
            _bmd = new BitmapData(stage.stageWidth, stage.stageHeight);
            this.addChild(new Bitmap(_bmd));
            
            var textWidth:uint = _charSize * CHARS.length + CHAR_MARGIN * (CHARS.length - 1);
            var textHeight:uint = _charSize;
            var centeringHorizontalOffset:uint = uint((stage.stageWidth - textWidth) / 2);
            var centeringVerticalOffset:uint = uint((stage.stageHeight - textHeight) / 2);
            
            _fixPoints = new Array();
            for (var i:uint = 0; i < CHARS.length; i++){     
                var charOffset:uint = (_charSize + CHAR_MARGIN) * i;
                for each(var obj:Object in CHARS[i]){
                    _fixPoints.push(new Point((DOT_MARGIN + DOT_WIDTH) * obj.x + charOffset + centeringHorizontalOffset, (DOT_MARGIN + DOT_HEIGHT) * obj.y + centeringVerticalOffset));
                }
            }
            
            _dots = new Array();
            for (var j:uint = 0; j < _fixPoints.length; j++){
                _dots.push(new Dot(stage.stageWidth * Math.random(), stage.stageHeight * Math.random()));
            }
            
            this.addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
        }
        
        private function onEnterFrameHandler(event:Event):void
        {
           _bmd.lock();
           _bmd.colorTransform(_bmd.rect, new ColorTransform(1, 1, 1, 0));
           for (var i:uint = 0; i < _dots.length; i++){
               var dx:Number = _fixPoints[i].x - _dots[i].x;
               var dy:Number = _fixPoints[i].y - _dots[i].y;
               var angle:Number = Math.atan2(dy, dx);
               var vx:Number = Math.cos(angle) * SPEED;
               var vy:Number = Math.sin(angle) * SPEED;
               
               if(Math.abs(dx) < SPEED){
                   _dots[i].x = _fixPoints[i].x;
               } else {
                   _dots[i].x += vx;
               }
               
               if(Math.abs(dy) < SPEED){
                   _dots[i].y = _fixPoints[i].y;
               } else {
                   _dots[i].y += vy;
               }
               
               drawDot(_dots[i].x, _dots[i].y);
           }
           _bmd.unlock();
        }
        
        private function drawDot(posX:Number, posY:Number):void
        {
            var s:Sprite = new Sprite();
            s.graphics.beginFill(DOT_COLOR);
            s.graphics.drawRect(posX, posY, DOT_WIDTH, DOT_HEIGHT);
            s.graphics.endFill();
            _bmd.draw(s);
        }
    }
}

class Dot {
    private var _x:int;
    private var _y:int;
    
    public function Dot(x:Number, y:Number)
    {
        _x = x;
        _y = y;
    }
    
    public function set x(value:Number):void
    {
        _x = value;
    }
    
    public function set y(value:Number):void
    {
        _y = value;
    }
    
    public function get x():Number
    {
        return _x;
    }
    
    public function get y():Number
    {
        return _y;
    }
}
