/**
 * Copyright hacker_fweb6nb7 ( http://wonderfl.net/user/hacker_fweb6nb7 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dQTP
 */

// forked from KoheiTAKAMIYA's なんちゃってMineSweeper
//暇つぶしによくやるあれ

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import com.bit101.components.PushButton;

	public class MineSweeper extends Sprite {
		private static const COLMN:uint = 20;	//マス行数
		private static const ROW:uint = 20;	//マス列数
		private static const MINE:uint = 50;	//地雷の数

		private var cellArray:Array = new Array();
		private var bt:PushButton;
		//初期化
		public function MineSweeper() {
			Wonderfl.disable_capture();
			var cell:MineCell;
			var mine:uint = MINE;
			var array:Array;
			//配置
			for(var i:uint=0;i<ROW;i++){
				array = new Array();
				for(var j:uint=0;j<COLMN;j++){
					if(COLMN-(j+1)+COLMN*(ROW-(i+1)) == mine || Math.round(Math.random()*3)==2){
						mine--;
						cell = new MineCell(j,i,true);
					}
					else cell = new MineCell(j,i,false);
					cell.x = j*18+40
					cell.y = i*18+40;
					cell.addEventListener("sweep", mineSweep);
					addChild(cell);
					array.push(cell);
				}
				cellArray.push(array);
			}
			bt = new PushButton(this,40,420,"try again",resetCells);
		}
		//リセットボタン
		private function resetCells(event:Event):void{
			var array:Array;
			var cell:MineCell;
			var mine:uint = MINE;
			for each(array in cellArray){
				for each(cell in array){
					cell.reset();
					if(COLMN-(cell.colmn+1)+COLMN*(ROW-(cell.row+1)) == mine || Math.round(Math.random()*3)==2){
						mine--;
						cell.mine = true;
					}
				}
			}
		}
		
		//マスを押したときの判定
		private function mineSweep(event:Event):void{
			var target:MineCell = event.target as MineCell;
			//押したマスが地雷だったら
			if(target.mine) {
				gameover();
				return;
			}
			//地雷じゃなかったら地雷の数をチェック
			check(target.colmn,target.row);
		}
		
		//周りにいくつ地雷があるかチェック
		private function check(colmn:uint, row:uint, recursion:Boolean = false):void{
			//再帰処理かどうか
			if(recursion){
				if(cellArray[row][colmn].sweep) return;
				cellArray[row][colmn].cellIcon("mouseUp");
			}
			var count:uint = 0;
			//周囲の地雷の数をチェック
			if(row > 0){
				if(colmn > 0) if(cellArray[row-1][colmn-1].mine) count++;
				if(colmn < COLMN-1) if(cellArray[row-1][colmn+1].mine) count++;
				if(cellArray[row-1][colmn].mine) count++;
			}
			if(colmn > 0) if(cellArray[row][colmn-1].mine) count++;
			if(colmn < COLMN-1) if(cellArray[row][colmn+1].mine) count++;
			if(row < ROW-1){
				if(colmn > 0) if(cellArray[row+1][colmn-1].mine) count++;
				if(colmn < COLMN-1) if(cellArray[row+1][colmn+1].mine) count++;
				if(cellArray[row+1][colmn].mine) count++;
			}
			
			//周囲に地雷がなかったら地雷あるところまで広がる
			//再帰処理で対応
			if(count == 0){
				if(row > 0) {
					if(colmn > 0) check(colmn-1,row-1,true);
					if(colmn < COLMN-1) check(colmn+1,row-1,true);
					check(colmn,row-1,true);
				}
				if(colmn > 0) check(colmn-1,row,true);
				if(colmn < COLMN-1) check(colmn+1,row,true)
				if(row < ROW-1){
					if(colmn > 0) check(colmn-1,row+1,true);
					if(colmn < COLMN-1) check(colmn+1,row+1,true);
					check(colmn,row+1,true);
				}
				return;
			}
			//地雷があったら地雷の数を表示
			cellArray[row][colmn].setNumber(count);
		}
		
		//地雷を踏んだら全部めくる
		private function gameover():void{
			var array:Array;
			var cell:MineCell;
			for each(array in cellArray){
				for each(cell in array){
					cell.cellIcon("gameover");
				}
			}
		}
	}
}

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.events.Event;
import flash.events.MouseEvent;

class MineCell extends Sprite{
	public var mine:Boolean;			//地雷かどうか
	public var sweep:Boolean = false;	//めくったかどうか
	public var colmn:uint;
	public var row:uint;
	public var text:TextField;
	private var txtFormat:TextFormat = new TextFormat();
	
	public function MineCell(colmn:uint,row:uint,mine:Boolean):void{
		this.colmn = colmn;
		this.row = row;
		this.mine = mine;
		cellIcon("");
		this.addEventListener(MouseEvent.ROLL_OVER,mouseFunction);
		this.addEventListener(MouseEvent.ROLL_OUT,mouseFunction);
		this.addEventListener(MouseEvent.MOUSE_DOWN,mouseFunction);
		this.addEventListener(MouseEvent.MOUSE_UP,mouseFunction);
	}
	public function mouseFunction(event:MouseEvent):void{
		parent.addChild(this);
		cellIcon(event.type);
	}
	
	//簡単なGUIの処理
	public function cellIcon(type:String):void{
		//めくったかどうか
		if(sweep) return;
		var lineColor:uint = 0x666666;
		var fillColor:uint = 0xffffff;
		//イベントの種類で塗りと線色を変える
		switch(type){
			case MouseEvent.MOUSE_DOWN:
				//塗り&線色を変える（breakしない）
				fillColor = 0x99ffff;
			case MouseEvent.ROLL_OVER:
				//線色だけ変える
				lineColor = 0x44dddd;
			break;
			case MouseEvent.MOUSE_UP:
				//めくった処理
				if(mine) fillColor = 0xff5500;//地雷ならオレンジ
				else fillColor = 0xaaaaaa;	 //それ以外はグレー
				sweep = true;				 //めくりました
				dispatchEvent(new Event("sweep"));//めくりましたイベント送出
			break;
			case "gameover":
				//ゲームオーバーの処理
				sweep = true;
				if(mine) fillColor = 0xff0000;//地雷なら赤
			break;
		}
		//描画
		this.graphics.clear();
		this.graphics.lineStyle(1.3, lineColor);
		this.graphics.beginFill(fillColor);
		this.graphics.drawRect(0,0,18,18);
		this.graphics.endFill();
	}
	
	//地雷数を表示
	public function setNumber(num:uint):void{
		if(text) return;
		text = new TextField();
		text.mouseEnabled = false;
		text.width = text.height = 18;
		txtFormat.align = "center";
		txtFormat.bold = true;
		txtFormat.color = (num > 4 ? 0xff0000 : num > 3 ? 0xff5500 : num > 2 ? 0xaa4444 : 0x000000);
		text.defaultTextFormat = txtFormat;
		text.text = String(num);
		addChild(text);
	}
	
	//リセット
	public function reset():void{
		sweep = false;
		mine = false;
		cellIcon("");
		if(!text) return;
		removeChild(text);
		text = null;
	}
}