/**
 * Copyright y_tama ( http://wonderfl.net/user/y_tama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dQ1U
 */

// forked from wh0's flash on 2011-8-29
package {
    import flash.display.*;
    import flash.events.*;
    public class FlashTest extends Sprite {
        
        private var n:uint = 0;
        
        public function FlashTest() {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            addEventListener(Event.ENTER_FRAME, frame);
        }
        
        private function frame(e:Event):void {
            var v:Number = 0;
            for (var b:uint = 1; b; b <<= 1) {
                var step:Number = 0.5 / b;
                var delta:Number = Math.round((1/3) / step) * step;
                if (n & b) v += delta;
            }
            new Dot(v, this);
            n++;
        }
        
    }
}

import flash.display.*;
import flash.events.*;

internal class Dot extends Shape {
    
    private static const far:Number = 465 * Math.SQRT1_2 + 20;
    
    private static function hue(r:uint):uint {
        return (
            0x010000 * Math.max(0, Math.min(0xff, Math.abs(r - 0x300) - 0x100)) +
            0x000100 * Math.max(0, Math.min(0xff, 0x200 - Math.abs(r - 0x200))) +
                       Math.max(0, Math.min(0xff, 0x200 - Math.abs(r - 0x400)))
        );
    }
    
    private var distance:Number = 1;
    
    public function Dot(v:Number, parent:DisplayObjectContainer) {
        graphics.beginFill(hue((v * 0x600) % 0x600));
        var t:Number = Math.PI * 2 * v;
        graphics.drawCircle(far * Math.sin(t), -far * Math.cos(t), 20);
        graphics.endFill();
        x = y = 232.5;
        parent.addChild(this);
        addEventListener(Event.ENTER_FRAME, frame);
    }
    
    private function frame(e:Event):void {
        distance += 0.05;
        if (distance >= 16) {
            removeEventListener(Event.ENTER_FRAME, frame);
            parent.removeChild(this);
        } else {
            scaleX = scaleY = 1 / distance;
            alpha = Math.min(1, 2 / distance / distance);
        }
    }
    
}