/**
 * Copyright Jeyasingh1985 ( http://wonderfl.net/user/Jeyasingh1985 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dPcc
 */

// forked from ferv's GraphicsPathでdrawEllipse()する
package  
{
	import com.bit101.components.CheckBox;
	import com.bit101.components.Slider;
	import flash.display.Graphics;
	import flash.display.GraphicsSolidFill;
	import flash.display.GraphicsStroke;
	import flash.display.IGraphicsData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextFormat;
	
	/**
	 * http://ferv.jp/blog/2009/10/28/graphicspath-drawellipse/
	 * 
	 * @langversion ActionScript 3.0
	 * @playerversion Flash 10.0
	 * 
	 * @author dsk
	 * @since 2009/10/27
	 */
	public class RountRectGraphicsPath extends Sprite
	{
		
		//--------------------------------------
		// CLASS CONSTANTS
		//--------------------------------------
		
		
		//--------------------------------------
		// PRIVATE VARIABLES
		//--------------------------------------
		
		private var _width:Slider;
		private var _height:Slider;
		
		
		//--------------------------------------
		// GETTER/SETTERS
		//--------------------------------------
		
		
		//--------------------------------------
		// CONSTRUCTOR
		//--------------------------------------
		
		public function RountRectGraphicsPath() 
		{
			_width = new Slider(Slider.HORIZONTAL, this, 190, 0, _onChange);
			_height = new Slider(Slider.VERTICAL, this, 0, 190, _onChange);
			_height.maximum = 300;
			_width.maximum = 300;
			_width.value = 300;
			_height.value = 150;
			
			_onChange();
		}
		
		
		//--------------------------------------
		// PUBLIC METHODS
		//--------------------------------------
		
		
		//--------------------------------------
		// PRIVATE METHODS
		//--------------------------------------
		
		private function _onChange(e:Event = null):void 
		{
			var width:Number = _width.value;
			var height:Number = _height.value;
			var x:Number = (stage.stageWidth - width) / 2;
			var y:Number = (stage.stageHeight - height) / 2;
			
			var g:Graphics = graphics;
			g.clear();
			g.lineStyle(4, 0x008CD2);
			g.drawEllipse(x, y, width, height);
			
			g.drawGraphicsData(Vector.<IGraphicsData>([
				new GraphicsStroke(2, false, 'normal', 'none', 'round', 3, new GraphicsSolidFill(0x000000, 1)),
				GraphicsPathUtil.createEllipse(x, y, width, height)
			]));
		}
		
		
	}
	
	
}



import flash.display.GraphicsPath;
import flash.display.GraphicsPathCommand;

internal class GraphicsPathUtil 
{
	
	private static const ELLIPSE_RATIO:Number = Math.SQRT2 - 1;
	
	public static function createEllipse(x:Number, y:Number, width:Number, height:Number, winding:String = 'evenOdd'):GraphicsPath 
	{
		width /= 2;
		height /= 2;
		x += width;
		y += height;
		
		var commands:Vector.<int> = new Vector.<int>();
		var data:Vector.<Number> = new Vector.<Number>();
		var i:int, signX:int, signY:int;
		
		for (i = 0; i < 4; i ++) {
			signX = (i == 0 || i == 3)? 1: -1;
			signY = (i == 0 || i == 1)? 1: -1;
			
			var points:Array = [
				[x + width * signX,                 y],
				[x + width * signX,                 y + height * ELLIPSE_RATIO * signY],
				[x + width * Math.SQRT1_2 * signX,  y + height * Math.SQRT1_2 * signY],
				[x + width * ELLIPSE_RATIO * signX, y + height * signY],
				[x,                                 y + height * signY]
			];
			if (i % 2 != 0) points.reverse();
			points.shift();
			
			commands.push(GraphicsPathCommand.CURVE_TO, GraphicsPathCommand.CURVE_TO);
			points = points[0].concat(points[1], points[2], points[3]);
			data.push.apply(null, points);
		}
		commands.unshift(GraphicsPathCommand.MOVE_TO);
		data.unshift(x + width, y);
		
		return new GraphicsPath(commands, data, winding);
	}
	
	
}









