/**
 * Copyright fumix ( http://wonderfl.net/user/fumix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dOra
 */

/**
* wonderfl QuickBox2D対応記念
* http://www.planet-ape.net/blog/archives/826
**/
package {
	import flash.events.MouseEvent;

	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.Joints.b2RevoluteJoint;

	import com.actionsnippet.qbox.QuickBox2D;
	import com.actionsnippet.qbox.QuickObject;

	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;

	[SWF(width = 465, height = 465, backgroundColor = 0x222222, frameRate = 60)]

	/**
	 * @author fumix
	 */
	public class Main extends MovieClip {
		private var sim : QuickBox2D;
		private var objectArray:Array;
		private var debugTextField : TextField;

		/**
		 * コンストラクタ
		 */
		public function Main() {
			//ボタン設置
			var resetButtonText : TextField = new TextField();
			resetButtonText.selectable = false;
			resetButtonText.text = "リセット";
			resetButtonText.autoSize = TextFieldAutoSize.LEFT;
			resetButtonText.background = true;
			resetButtonText.backgroundColor = 0x666666;
			resetButtonText.border = true;
			resetButtonText.x = 20;
			resetButtonText.y = 20;
			addChild(resetButtonText);
			resetButtonText.addEventListener(MouseEvent.CLICK, onRestButtonClick);
			//テキストエリア設置
			debugTextField = new TextField();
			debugTextField.textColor = 0xFFFFFF;
			debugTextField.multiline = true;
			debugTextField.width = 200;
			debugTextField.height = 150;
			debugTextField.x = 20;
			debugTextField.y = 40;
			addChild(debugTextField);

			//QuickBox2D初期設定
			sim = new QuickBox2D(this);
			sim.setDefault({fillColor:0x000000, lineColor:0xCCCCCC});
			sim.createStageWalls();

			//オブジェクト10個生成
			objectArray = new Array();
			for (var i : int = 0; i < 10; i++) {
				objectArray.push(creatObject());
			}
			//各ジョイントの回転角度制限
			for (i = 0;i < objectArray.length;i++) {
				resetObject(objectArray[i]);
			}
			//各ジョイントの角速度設定
			for (i = 0;i < objectArray.length;i++) {
				setWalkDir(3,objectArray[i]);
			}

			//フレーム毎の動き
			addEventListener(Event.ENTER_FRAME, onLoop);
			//スタート
			sim.start();
			sim.mouseDrag();
		}

		private function onRestButtonClick(event : MouseEvent) : void {
			//各ジョイントの回転角度制限
			for (var i:int = 0;i < objectArray.length;i++) {
				resetObject(objectArray[i]);
			}
		}

		/**
		 * オブジェクトの生成
		 */
		private function creatObject() : Object {
			sim.setDefault({fillColor:0x000000, lineColor:0xCCCCCC});
			var legA : QuickObject = sim.addBox({x:2, y:5, width:1.5, height:0.3, groupIndex:-2});
			var legB : QuickObject = sim.addBox({x:2 + 1.3, y:5, width:1.5, height:0.3, groupIndex:-2});
			var legC : QuickObject = sim.addBox({x:2 + 1.3 * 2, y:5, width:1.5, height:0.3, groupIndex:-2});
			var legD : QuickObject = sim.addBox({x:2 + 1.3 * 3, y:5, width:1.5, height:0.3, groupIndex:-2});
			//ジョイントの設置
			sim.setDefault({type:"revolute"});
			var anchorX : Number = legA.x + (legB.x - legA.x) / 2;
			var anchorY : Number = legA.y;
			var revJointA : QuickObject = sim.addJoint({enableLimit:true, a:legA.body, b:legB.body, x1:anchorX, y1:anchorY, enableMotor:true, maxMotorTorque:80});

			anchorX = legB.x + (legC.x - legB.x) / 2;
			var revJointB : QuickObject = sim.addJoint({enableLimit:true, a:legB.body, b:legC.body, x1:anchorX, y1:anchorY, enableMotor:true, maxMotorTorque:80});

			anchorX = legC.x + (legD.x - legC.x) / 2;
			var revJointC : QuickObject = sim.addJoint({enableLimit:true, a:legC.body, b:legD.body, x1:anchorX, y1:anchorY, enableMotor:true, maxMotorTorque:80});

			return {a:legA,b:legB, c:legC, d:legD, jointA:revJointA, jointB:revJointB, jointC:revJointC};
		}

		private function resetObject(obj:Object) : void {
			var j : b2RevoluteJoint;
			var legA:QuickObject = obj.a;
			var legB:QuickObject = obj.b;
			var legC:QuickObject = obj.c;
			var legD:QuickObject = obj.d;
			var revJointA:QuickObject = obj.jointA;
			var revJointB:QuickObject = obj.jointB;
			var revJointC:QuickObject = obj.jointC;

			var angleA : Number = Math.PI * Math.random();
			j = revJointA.joint as b2RevoluteJoint;
			j.SetLimits(-angleA, angleA);

			var angleB : Number = Math.PI * Math.random();
			j = revJointB.joint as b2RevoluteJoint;
			j.SetLimits(-angleB, angleB);

			var angleC : Number = Math.PI * Math.random();
			j = revJointC.joint as b2RevoluteJoint;
			j.SetLimits(-angleC, angleC);

			debugTextField.htmlText = 'A:' + angleA * 180 / Math.PI;
			debugTextField.htmlText += 'B:' + angleB * 180 / Math.PI;
			debugTextField.htmlText += 'C:' + angleC * 180 / Math.PI;

			//速度をリセット
			var v : b2Vec2 = legA.body.GetLinearVelocity();
			v.Set();
			legA.body.SetLinearVelocity(v);
			legB.body.SetLinearVelocity(v);
			legC.body.SetLinearVelocity(v);
			legD.body.SetLinearVelocity(v);
			legA.setLoc(2, 5);
			legB.setLoc(2+1.3, 5);
			legC.setLoc(2+1.3*2, 5);
			legD.setLoc(2+1.3*3, 5);
		}

		private function onLoop(event : Event) : void {
			//setWalkDir(2);
			for (var i:int = 0;i < objectArray.length;i++) {
				repeatWalk(objectArray[i]);
			}
		}

		private function setWalkDir(dir : Number,obj:Object) : void {
			var j : b2RevoluteJoint;
			var revJointA:QuickObject = obj.jointA;
			var revJointB:QuickObject = obj.jointB;
			var revJointC:QuickObject = obj.jointC;

			j = revJointA.joint as b2RevoluteJoint;
			j.SetMotorSpeed(dir);
			j = revJointB.joint as b2RevoluteJoint;
			j.SetMotorSpeed(dir * -1);
			j = revJointC.joint as b2RevoluteJoint;
			j.SetMotorSpeed(dir);
		}

		private function repeatWalk(obj:Object) : void {
			var revJointA:QuickObject = obj.jointA;
			var revJointB:QuickObject = obj.jointB;
			var revJointC:QuickObject = obj.jointC;
			var j : b2RevoluteJoint;
			j = revJointA.joint as b2RevoluteJoint;
			if(j.GetLowerLimit() > j.GetJointAngle() || j.GetUpperLimit() < j.GetJointAngle()) j.SetMotorSpeed(j.GetMotorSpeed() * -1);
			j = revJointB.joint as b2RevoluteJoint;
			if(j.GetLowerLimit() > j.GetJointAngle() || j.GetUpperLimit() < j.GetJointAngle()) j.SetMotorSpeed(j.GetMotorSpeed() * -1);
			j = revJointC.joint as b2RevoluteJoint;
			if(j.GetLowerLimit() > j.GetJointAngle() || j.GetUpperLimit() < j.GetJointAngle()) j.SetMotorSpeed(j.GetMotorSpeed() * -1);
		}
	}
}
