/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dOex
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=118
    public class Euler118 extends Sprite {
        private var _tf : TextField;
  
        public function Euler118() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            _tf.appendText("" + solve() + "\n");
            var g : int = getTimer();
            _tf.appendText("" + (g - s) + " ms\n");
        }
        
        private function solve() : int
        {
            var base : Array = [1, 2, 3, 4, 5, 6, 7, 8, 9];
            var ds : Array = new Array(5);
            var ct : int = 0;
            var ns : Array = new Array(6);
            var n : Number, o : Number;
            do{
                for(ds[0] = 0;ds[0] <= 1;ds[0]++){
                    n = sumup(base, 0, ds[0]);
                    if(!isPrime(n) && n > 0)continue;
                    ns[0] = n;
                for(ds[1] = ds[0] + ds[0];ds[1] <= ds[0] + 1;ds[1]++){
                    n = sumup(base, ds[0], ds[1]);
                    if(n < ns[0] || (!isPrime(n) && n > 0))continue;
                    ns[1] = n;
                for(ds[2] = ds[1] + (ds[1] - ds[0]);ds[2] <= ds[1] + 2;ds[2]++){
                    n = sumup(base, ds[1], ds[2]);
                    if(n < ns[1] || (!isPrime(n) && n > 0))continue;
                    ns[2] = n;
                for(ds[3] = ds[2] + (ds[2] - ds[1]);ds[3] <= ds[2] + 3;ds[3]++){
                    n = sumup(base, ds[2], ds[3]);
                    if(n < ns[2] || (!isPrime(n) && n > 0))continue;
                    ns[3] = n;
                for(ds[4] = Math.max(1, ds[3] + (ds[3] - ds[2]));ds[4] <= ds[3] + 4;ds[4]++){
                    n = sumup(base, ds[3], ds[4]);
                    if(n < ns[3] || (!isPrime(n) && n > 0))continue;
                    o = sumup(base, ds[4], 9); 
                    if(o < n || !isPrime(o))continue;
                    ns[4] = n;
                    ns[5] = o;
//                    _tf.appendText("" + ns + "\n");
                    ct++;
                }
                }
                }
                }
                }
                
            }while(nextPermutation(base));
            return ct;
        }
        
        private static function sumup(a : Array, s : int, e : int) : Number
        {
            var ret : Number = 0;
            for(var i : int = s;i < e;i++){
                ret = ret * 10 + a[i];
            }
            return ret;
        }
        
        private var _cache : Object = {};
        
        private function isPrime(n : Number) : Boolean
        {
            if(n <= 1)return false;
            if(n % 2 == 0)return n == 2;
            if(_cache[n])return _cache[n];
            
            var sq : int = Math.sqrt(n);
            for(var i : int = 3;i <= sq;i+=2){
                if(n % i == 0){
                    _cache[n] = false;
                    return false;
                }
            }
            _cache[n] = true;
            return true;
        }
        
        private function nextPermutation(src : Array) : Array
        {
            for(var i : int = src.length - 2;i >= 0 && src[i] > src[i + 1];i--);
            if(i == -1)return null;
            for(var j : int = i + 1;j < src.length && src[i] < src[j];j++);
            var d : int;
            d = src[i]; src[i] = src[j - 1]; src[j - 1] = d;
            for(var p : int = i + 1, q : int = src.length - 1;p < q;p++, q--){
                d = src[p]; src[p] = src[q]; src[q] = d;
            }
            return src;
        }    }
}