/**
 * Copyright Kihara ( http://wonderfl.net/user/Kihara )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/dO23
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Back;
	import org.libspark.betweenas3.tweens.ITween;
	import org.papervision3d.materials.special.Letter3DMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.typography.Text3D;
	import org.papervision3d.typography.VectorLetter3D;
	import org.papervision3d.typography.fonts.HelveticaBold;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.ViewportLayer;

	[SWF(backgroundColor = 0xffffff)]
	public class text extends BasicView
	{
		private var word:Text3D;
		private var angle:Number = 0;
		private var cnt:Number = 0;
		private var RADIUS:Number = 500;
		
		public function text()
		{
			word = new Text3D("Hello!World!I am a student.",new HelveticaBold(),null);
			
			for(var i:int = 0 ; i < word.letters.length ; i++){
				var char:VectorLetter3D = word.letters[i];
				var mat:Letter3DMaterial = new Letter3DMaterial(Math.random()*0xffffff);
				
				
				mat.doubleSided = true;
				char.material = mat;
				
				char.extra = {x:char.x,y:char.y,z:char.z};
				char.x = Math.random()*1000-500;
				char.y = Math.random()*1000-500;
				char.z = Math.random()*1000-500;
				char.localRotationX = Math.random()*100;
				char.localRotationY = Math.random()*100;
				char.localRotationZ = Math.random()*100;
				
			}
			
			word.useOwnContainer = true;
			scene.addChild(word);
			
			
			startRendering();
			addEventListener(Event.ENTER_FRAME,onFrame);
			
			
		}
		private function tween(i:int):void{
			var l:VectorLetter3D = word.letters[i];
			var t:ITween = BetweenAS3.to(l,{x:l.extra.x,y:l.extra.y,z:l.extra.z},0.5,Back.easeInOut);
			
			if(i+1 != word.letters.length){
				t.onComplete = tween;
				t.onCompleteParams = [i+1];
				
			}
			else{
				t.onComplete = tween2;
				
			}
			t.play();
			
		}
		private function tween2():void{
			for(var i:int = 0 ; i < word.letters.length ; i++){
				BetweenAS3.to(word.letters[i],{rotationY:360},1.5,Back.easeInOut).play();
			}
		}
		private function onFrame(event:Event):void{
			cnt += 0.005;
			
			camera.x = Math.cos(cnt)*RADIUS+Math.sin(cnt*2)*RADIUS;
			camera.y = Math.sin(cnt*2)*RADIUS-Math.cos(cnt*0.5)*RADIUS;
			camera.z = 0.5*Math.sin(cnt)*RADIUS+Math.cos(cnt*5)*RADIUS;
			
			//setBlur(word);
			
		}
		
		private function setBlur(words:Text3D):void{
			for each(var moji:DisplayObject3D in words.letters){
				var vpl:ViewportLayer = moji.createViewportLayer(viewport,true);
				var dis:Number = Math.abs(camera.distanceTo(moji)-RADIUS);
				var d:uint = Math.min(30,dis*0.015);
				
				vpl.filters = [new BlurFilter(d,d,1)];
				
			}
		}
		
	}
}