/**
 * Copyright Hasufel ( http://wonderfl.net/user/Hasufel )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dNCr
 */

package {

    //**********************************************************************************
    //LittleAnimEngine
    //@by Hasufel 2010
    //A little engine for sprite animation.
    //***********************************************************************************/

    import flash.display.StageQuality;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;

    import flash.geom.Rectangle;
    import flash.geom.Point;

    import flash.events.Event;

    import flash.utils.ByteArray;
    import flash.utils.Timer;
    import flash.utils.getTimer;
    import net.hires.debug.Stats;

    [SWF(width="465", height="465", backgroundColor="0", frameRate="60")]
        
    public class LittleAnimEngine extends Sprite {
        private const _howmany:uint = 100; //how many sprites ?
        private const _stageH:int = stage.stageHeight;
        private const _stageW:int = stage.stageWidth;
        private const _point:Point = new Point();
        private const _graphicsData:Array =["47494638396116001600b30900000000e76342e7c6630063e7e742e7e7e7e763212142424200c6e7ffffff00000000000000000000000000000000000021f90401000009002c000000001600160000046d30c949abbd38ebcdbbff20758ce48195e480aceb809a07cbaaf22cc33492d7ed6a4aa91d6035f4fd443b44b1883822793ce7e4b02b58af3aa9c440455cbf0581cb62201804687058a04d94cd01b41c1d30182e6f3b779437e309667e5b8065776484826e8486787a1576211c11003b",
"47494638396116001600b30a00e7a563000000e76342e742e7e7e7e7e7c6630063e763212142424200c6e7ffffff00000000000000000000000000000021f9040100000a002c0000000016001600000482504989a69df5e29435e21a05865f7721c5687dea999a62bbbe486d1b898c15a981e73e1c6c57f8e58ec29002653c2287a2662037354097cdc4549bbb22b2ceaef2db249809625210706eeb300640a16d2e5e1587839cc7e71d94780303070200868602798007827907088e8c7f4a8c8383819693219592988a80788e139fa0a52111003b"];
        
        private var loader:Loader;
        private var assetsMemoryBank:Array=[];
        private var assetsNum:int = 0;

        public function LittleAnimEngine() {
            setProps(stage, {quality:StageQuality.LOW,scaleMode:StageScaleMode.NO_SCALE,align:StageAlign.TOP_LEFT});
            var blackBg:Bitmap = new Bitmap(new BitmapData(465,465,false,0x000000));
            addChild(blackBg);
            prepareAsset(0);
        }

        private function prepareAsset(n:int):void{
            var bytes:ByteArray = new ByteArray();
            var data1:Array=_graphicsData[n].split("");
            var data2:Array=[];
            var d1l:int = data1.length;
            for (var i:int=0;i<d1l;i+=2){
                data2.push("0x"+data1[i]+data1[i+1]);
            }
            var d2l:int = data2.length;
            for (var j:int=0;j<d2l;j++){
                bytes[j] = data2[j];
            }
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE,assetsLoaded);
            loader.loadBytes(bytes);
        }

        private function assetsLoaded(event:Event):void {
            assetsMemoryBank.push(loader.content);
            assetsNum++;
            if (assetsNum<_graphicsData.length) {prepareAsset(assetsNum);}
            else {initGame();}
        }

        private function initGame():void{
            for (var i:uint=0;i<_howmany;i++){
                var anim:DataSprite = new DataSprite();
                anim.vars[0]=0;
                anim.vars[1]=0;
                animateImagesInit(anim,[0,1],randomNumber(50,150));
                setProps(anim, {name:'a_'+i, x:randomNumber(0,_stageW), y:randomNumber(0,_stageH)});
                addChild(anim);
            }
            addChild(new Stats());
            addEventListener(Event.ENTER_FRAME,checkForNextPath);
        }

        private function checkForNextPath(e:Event):void {
            //bogus function just to move the sprites a bit around :)
            for (var i:uint=0;i<_howmany;i++){
                var t:* = getChildByName("a_"+i);
                var v:uint = randomNumber(0,10)>9?1:0;
                if (v==1){
                    var newX:uint = randomNumber(10,_stageW);
                    var newY:uint = randomNumber(10,_stageH);
                    var dx:int = newX - t.x;
                    var dy:int = newY - t.y;
                    var d:Number = Math.sqrt(dx * dx + dy * dy);
                    t.vars[0] = dx/d*2;
                    t.vars[1] = dy/d*2;
                }
                t.x+=t.vars[0];
                t.y+=t.vars[1];
            }        
        }

        private function animateImagesInit(tgt:*, imAr:Array, spd:uint):void {
            //imAr are the reference to images stored in assetsMemoryBank, considered here as frames.
            //spd is the animation delay between two frames in milliseconds.
            var e:DataSprite = new DataSprite();
            var xx:uint = assetsMemoryBank[imAr[0]].bitmapData.width;
            var yy:uint = assetsMemoryBank[imAr[0]].bitmapData.height;
            
            var bmp:Bitmap = e.addChild(new Bitmap(new BitmapData(xx,yy,true,0x00FFFFFF))) as Bitmap;
            setProps(bmp,{name:'b'});

            e.vars[0] = imAr;//images array ref
            e.vars[1] = 0; //frame counter
            e.vars[2] = new Rectangle(0,0,xx,yy); //xx and yy dimensions for the animation
            e.vars[3] = spd;//animation frequence in milliseconds.
            e.vars[4] = getTimer(); //init timer.
             e.addEventListener(Event.ENTER_FRAME,animateImages);
            tgt.addChild(e);
        }

        private function animateImages(e:Event):void{
            var t:* = e.target;
            if (getTimer() - t.vars[4]>t.vars[3]) {
                t.vars[4] = getTimer();
                var b:BitmapData = t.getChildByName('b').bitmapData;
                b.lock();
                b.fillRect(t.vars[2],0x00FFFFFF);
                b.copyPixels(assetsMemoryBank[t.vars[0][t.vars[1]]].bitmapData,t.vars[2],_point);
                b.unlock();
                t.vars[1] = (++t.vars[1])%t.vars[0].length;
            }
        }

        private function setProps(o:*,p:Object):void {
            for (var k:String in p) {o[k]=p[k];}
        }

        private function randomNumber(low:uint, high:uint):uint{
            return Math.round(Math.random() * (high - low) + low);
        }
    }
}

import flash.display.Sprite;
class DataSprite extends Sprite {
    public var vars:Array = []; 
}