/**
 * Copyright romatica ( http://wonderfl.net/user/romatica )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dN94
 */

/**
 * copyright (c) 2012 www.romatica.com
 * @author itoz
 */
package
{
    import away3d.containers.View3D;
    import away3d.core.base.SubGeometry;
    import away3d.debug.AwayStats;
    import away3d.entities.Mesh;
    import away3d.materials.ColorMaterial;
    import away3d.primitives.PlaneGeometry;

    import flash.events.Event;
    import flash.geom.Vector3D;
    import flash.utils.getTimer;
import flash.display.*;

    [SWF(backgroundColor="#FFFFFF", frameRate="60", width="465", height="465")]
    /**
     * Away3D 4.0 beta PlaneGeometryの頂点を移動し、布のゆらぎを表現
     */
    public class ClothMotion extends View3D
    {
        private static const ZERO : Vector3D = new Vector3D(0, 0, 0);
        private static const FLOW_RANGE : int = 100;
        private static const FLOW_SPEED : Number = 3;
        private static const  RAD_VAR : Number = (Math.PI / 180);
        private var _clothMat : ColorMaterial;
        private var _clothGeo : PlaneGeometry;
        private var _cloth : Mesh;
        private var _defs : Vector.<Number>;
        private var _angs : Vector.<Number>;

//private var source:BitmapData = new BitmapData(465, 465, false, 0x000000);
//private var _bm:Bitmap;
  
        public function ClothMotion()
        {
            

//Wonderfl.disable_capture();
//_bm = addChild(new Bitmap(source)) as Bitmap;

            antiAlias = 4;
            backgroundColor = 0xa1c3c0;

            // ----------------------------------
            // 布
            // ----------------------------------
            _clothMat = new ColorMaterial(0x408aa8);
            _clothMat.bothSides = true;
            _clothGeo = new PlaneGeometry(1024, 1024, 32, 32);
            _cloth = new Mesh(_clothGeo, _clothMat);
            _cloth.showBounds = true;
            scene.addChild(_cloth);

            // ----------------------------------
            // 揺らぎ用パラメータ
            // ----------------------------------
            var max : int = _cloth.geometry.subGeometries[0].vertexData.length;
            _defs = new Vector.<Number>(max);
            _angs = new Vector.<Number>(max);
            for (var i : int = 0; i < _defs.length; i++) {
                _defs[i] = _cloth.geometry.subGeometries[0].vertexData[i];
                _angs[i] = (360 / _defs.length * i );
            }




            camera.y = -1000;
            addChild(new AwayStats());
                    

            addEventListener(Event.ENTER_FRAME, update);
        }

        /**
         * アップデート
         */
        private function update(event : Event) : void
        {
            clothMotion();
            cameraMotion();
            // 描画
            render();
        }

        /**
         * 布頂点ゆらぎ
         */
        private function clothMotion() : void
        {
            var geo : SubGeometry = _clothGeo.subGeometries[0] as SubGeometry;
            var vlen : int = geo.vertexData.length;
            for (var i : int = 0; i < vlen;i++ ) {
                _angs[i] += (_angs[i] + FLOW_SPEED >= 360) ? FLOW_SPEED - 360 : FLOW_SPEED;
                var rad : Number = _angs[i] * RAD_VAR;
                var flow : int = Math.cos(rad) * FLOW_RANGE;
                geo.vertexData[i] = _defs[i] + flow;
            }
            geo.updateVertexData(geo.vertexData);
        }

        /**
         * カメラ移動
         */
        private function cameraMotion() : void
        {
            var range : int = 1500;
            var t : Number = getTimer() / range;
            camera.x = Math.sin(t) * range;
            camera.y = Math.cos(t) * range;
            camera.z = Math.cos(t) * range;
            camera.lookAt(ZERO);
//renderer.queueSnapshot(source);
        }
    }
}