/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dMoN
 */

/*
 * 参考：Twitterの検索z軸つき(http://wonderfl.net/c/g2Gi)
 * */
package
{
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.errors.IOError;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.text.TextField;
	import flash.text.TextFieldType;

	[SWF(width = "480", height = "480", backgroundColor = "0x000000", fps = "30")] 
	public class Practice74 extends Sprite {
		private var clip:MovieClip;
		private var list:Array;
		private var num:int = 60;
		private var trans:Number = 1.0;
		private var deg:Number = 0;
		private var rate:Number = 0.02;
		private var step:Number = 1.09;
		private var inc:Number = 24;
		private var w2:int = 240, h2:int = 240;
		private var text:TextField;
		private var doClear:Boolean = false;
		
		public function Practice74() {
			clip = new MovieClip();
			addChild(clip);
			list = new Array();
			addEventListener(Event.ENTER_FRAME, update);
			text = new TextField();
            text.x = 350, text.y = 450;
            text.type = TextFieldType.INPUT;
            text.restrict = null;
            text.width = 100;
            text.height = 20;
            text.border = true;
			text.text = "iPad";
			text.background = true;
			text.backgroundColor = 0xffffff;
			text.borderColor = 0xcccccc;
			text.border = true;
			text.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
            addChild(text);
			serch(text.text);
		}
		
		private function update(e:Event):void {
			if (doClear) {
				if (clip.numChildren > 0) clip.removeChildAt(0);
				if (list.length > 0) list.shift();
				if (clip.numChildren == 0) doClear = false;
			}else {
				if (clip.numChildren < list.length) clip.addChild(list[clip.numChildren]);
			}
		}
		
		private function onKeyUp(e:KeyboardEvent):void {
			if (e.keyCode == 13 && !doClear) {
				doClear = true;
				serch(e.currentTarget.text);
			}
		}
		
		private function serch(word:String):void {
			var loader:URLLoader = new URLLoader();
			loader.addEventListener(Event.COMPLETE, onCompleteXML);
//			loader.addEventListener(IOErrorEvent.IO_ERROR, function(e:IOError):void{});
			var xmlURL:String = "http://search.twitter.com/search.atom?q=";
			xmlURL += encodeURIComponent(word);
			xmlURL +="&rpp=60"
			loader.load(new URLRequest(xmlURL));
		}
		
		private function clear():void {
			while (clip.numChildren > 0) clip.removeChildAt(clip.numChildren - 1);
			while (list.length > 0) list.shift();
		}
		
		private function onCompleteXML(e:Event):void {
			e.currentTarget.removeEventListener(Event.COMPLETE, onCompleteXML);
			trans = 1.0, deg = 0;
			var myXML:XML = new XML(e.currentTarget.data);
			default xml namespace = new Namespace("http://www.w3.org/2005/Atom");
			var itemLength:int = myXML.entry.length();
			for (var i:int = 0; i < itemLength; i++) {
				var link:String = myXML.entry[i].link[0].@href;
				var authorName:String = myXML.entry[i].author.name;
				var title:String = myXML.entry[i].title;
				var imgURL:String = myXML.entry[i].link[1].@href;
				var extention:String = imgURL.substr( -4);
				extention = extention.toLowerCase();
				if (extention != ".jpg" && extention != ".gif" && extention != ".png") {
					imgURL = "http://s.twimg.com/a/1254440757/images/default_profile_mini.png";
				}
				imgURL = encodeURI(imgURL);
				var htmldata:String = "";
				htmldata += "<img src='" + imgURL + "' width='48' height='48' checkPolicyFile='true' />";
				htmldata += "<b>" + authorName + "</b> " + title + "";
				var c:Card = new Card();
				c.text.htmlText = htmldata;
				addCard(c);
			}
		}
		
		private function addCard(c:Card):void {
			c.x = trans * Math.PI * 2 * Math.cos(deg / 180 * Math.PI) + w2;
			c.y = trans * Math.PI * 2 * Math.sin(deg / 180 * Math.PI) + h2;
			c.scaleX = rate * trans, c.scaleY = c.scaleX;
			c.rotationZ = deg - 180;
			c.init();
			trans *= step;
			deg += inc;
			if (deg > 180) deg -= 360;
			list.push(c);
		}
	}

}
import flash.display.MovieClip;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.filters.DropShadowFilter;
import flash.text.TextField;
class Card extends MovieClip {
	public var text:TextField;
	private var roll:Boolean = false;
	private var sx:Number, sy:Number;
	private var deg:Number, scale:Number;
	
	public function Card():void {
		text = new TextField();
		text.width = 200;
		text.wordWrap = true;
		text.background = true;
		text.backgroundColor = 0xdddddd;
		text.border = true;
		text.selectable = false;
		text.borderColor = 0x888888;
		text.textColor = 0x333333;
		text.autoSize = "left";
		this.filters = [new DropShadowFilter(2, 90, 0x666666, 1, 8, 8)];
		addChild(text);
		this.alpha = 0.4;
	}
	
	public function init():void {
		deg = rotationZ, scale = scaleX;
		sx = x, sy = y;
		addEventListener(MouseEvent.ROLL_OVER, function(e:MouseEvent):void { roll = true; } );
		addEventListener(MouseEvent.ROLL_OUT, function(e:MouseEvent):void { roll = false; } );
		addEventListener(Event.ENTER_FRAME, update);
	}
	
	private function update(e:Event):void {
		if (roll) {
			if (parent.getChildIndex(this) != parent.numChildren-1) {
				parent.addChild(parent.removeChild(this));
			}
			x += (90 - x) / 20;
			y += (90 - y) / 20;
			alpha += (1.0 - alpha) / 20;
			if (alpha > 0.8) alpha = 1.0;
			scaleX += (1.5 - scaleX)/20;
			scaleY += (1.5 - scaleY)/20;
			rotationZ += (0 - rotationZ) / 20;
		}else {
			x += (sx - x) / 10;
			y += (sy - y) / 10;
			alpha += (0.4 - alpha)/10;
			scaleX += (scale - scaleX)/10;
			scaleY += (scale - scaleY)/10;
			rotationZ += (deg - rotationZ) / 10;
		}
	}
}