/**
 * Copyright muta244 ( http://wonderfl.net/user/muta244 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dLK8
 */

package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    static private const _NUM_TIMES:int = 1000000;
    static private const _DEGREES:Number = 30;
    
    static private const _TABLE_SIZE:int = 0x10000;
    static private const _PI:Number = Math.PI;
    static private const _RADIANS:Number = _DEGREES * (_PI / 180);
    static private const _TWO_PI:Number = 2 * _PI;
    static private const _TWO_PI_SCALE:Number = _TABLE_SIZE / _TWO_PI;
    static private const _HALF_PI:Number = _PI / 2;
    
    private var _table:Vector.<Number> = new function ():Vector.<Number>
    {
        var table:Vector.<Number> = new Vector.<Number>(_TABLE_SIZE, true);
        
        for (var i:uint = 0; i < _TABLE_SIZE; i++) {
            table[i] = Math.sin(i / _TWO_PI_SCALE);
        }
        
        return table;
    };
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        _debug("最初に計算の正当性を確認 (テーブルは " + _TABLE_SIZE + " 分割)\n");
        _debug(_DEGREES + " 度の sin を Math.sin() で計算 -> " + Math.sin(_RADIANS));
        _debug(_DEGREES + " 度の sin をテーブルから近似値を取得 -> " + _sin(_RADIANS));
        _debug(_DEGREES + " 度の cos を Math.cos() で計算 -> " + Math.cos(_RADIANS));
        _debug(_DEGREES + " 度の cos をテーブルから近似値を取得 -> " + _cos(_RADIANS) + "\n");
        
        _measure("ループのみ", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                
            }
        });
        
        _measure("Math.sin() で計算", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                Math.sin(_RADIANS);
            }
        });
        
        _measure("Math.cos() で計算", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                Math.cos(_RADIANS);
            }
        });
        
        _measure("関数を通したテーブルから sin の近似値を取得", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                _sin(_RADIANS);
            }
        });
        
        _measure("関数を通したテーブルから cos の近似値を取得", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                _cos(_RADIANS);
            }
        });
        
        _measure("テーブルから sin の近似値を直接取得", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                _table[(_RADIANS * _TWO_PI_SCALE) & (_TABLE_SIZE - 1)];
            }
        });
        
        _measure("テーブルから cos の近似値を直接取得", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                _table[((_RADIANS + _HALF_PI) * _TWO_PI_SCALE) & (_TABLE_SIZE - 1)];
            }
        });
        
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
    }
    
    private function _sin(radians:Number):Number
    {
        return _table[(radians * _TWO_PI_SCALE) & (_TABLE_SIZE - 1)];
    }
    
    private function _cos(radians:Number):Number
    {
        return _table[((radians + _HALF_PI) * _TWO_PI_SCALE) & (_TABLE_SIZE - 1)];
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
