/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dLHH
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shader;
    import flash.display.Shape;
    import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.Point;
    import flash.filters.ShaderFilter;
    import mx.utils.*;

	[SWF(width="465", height="465", backgroundColor="#000000", frameRate="30")]
	public class AlphaTest extends Sprite {

	
		public static const asShader:Vector.<String> = Vector.<String>([
			"pQEAAACkCQBhbHBoYVRlc3SgDG5hbWVzcGFjZQAxAKAMdmVuZG9yAEpXQgCgCHZl",
			"cnNpb24AAQCgDGRlc2NyaXB0aW9uAGFscGhhIHRlc3QAoQECAAAMX091dENvb3Jk",
			"AKMABG9JbWFnZQChAgQBAA9kc3QAHQAAMQAAEAAxAgDxAACwAB0DAPMCABsAMgQA",
			"gD8AAAAdAgCABAAAADIEAIA7o9cKHQQAQAAAgAADBABABAAAAB0CAEAEAEAAMgQA",
			"gDuj1wodBABAAADAAAMEAEAEAAAAHQIAIAQAQAAdAgAQAwDAAB0BAPMCABsA"]);

		public var filter:ShaderFilter, shader:Shader;
		
		public var dat:BitmapData, bmp:Bitmap;
		public var dat2:BitmapData, bmp2:Bitmap;
		public var dat3:BitmapData, bmp3:Bitmap;
		
		function AlphaTest() {
			Make();
		}
		
		public function Make():void {
			var bmp:Bitmap, dat:BitmapData, shp:Shape,
				iX:int, iY:int, fVal:Number, iVal:int;
		
			var dec:Base64Decoder = new Base64Decoder;
			dec.decode(asShader.join(""));
			filter = new ShaderFilter(shader = new Shader(dec.drain()));

			
			
			dat = new BitmapData(200, 200, true, 0);
			
			dat.lock();
			for (iX = 0; iX < 200; iX++) {
				for (iY = 0; iY < 200; iY++) {
					fVal = 1 + Math.sin(iX / 6) * Math.cos(iY / 6);
					iVal = Math.min(fVal * 255, 255);
					dat.setPixel32(iX, iY, (iVal << 24) + 0x808080);
				}
			}
			dat.unlock();
			
			dat2 = new BitmapData(200, 200, true, 0);
			dat2.applyFilter(dat, dat.rect, new Point(), filter);

			bmp = new Bitmap(dat);
			bmp2 = new Bitmap(dat2);
			bmp.x = 10;
			bmp2.x = 255;
                        bmp.y = bmp2.y = 125;
                        
                        dat3 = new BitmapData(465, 100, true, 0xff000000);
                        bmp3 = new Bitmap(dat3);
                        bmp3.y = 200;
                        
                        addChild(bmp3);
			addChild(bmp);
			addChild(bmp2);

		}
	}
}

/*
<languageVersion: 1.0;> 

kernel alphaTest
<   namespace : "1";
    vendor : "JWB";
    version : 1;
    description : "alpha test"; >
{
    input image4 oImage;
    output pixel4 dst;

    void
    evaluatePixel()
    {
        float2 relativePos = outCoord();
        pixel4 inCol = sampleNearest(oImage, relativePos);
        dst = pixel4(0.5, relativePos.x * 0.005, relativePos.y * 0.005, inCol.w);
    }
}
*/