/**
 * Copyright nacookan ( http://wonderfl.net/user/nacookan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dL7R
 */

package {
    import flash.display.*;
    import flash.events.*;
    import com.flashdynamix.motion.*;
    import fl.motion.easing.*;
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            addSprite(generateGraph(Back.easeIn), 0, 0);
            addSprite(generateGraph(Back.easeInOut), 70, 0);
            addSprite(generateGraph(Back.easeOut), 140, 0);
            
            addSprite(generateGraph(Bounce.easeIn), 210, 0);
            addSprite(generateGraph(Bounce.easeInOut), 280, 0);
            addSprite(generateGraph(Bounce.easeOut), 350, 0);
            
            addSprite(generateGraph(Circular.easeIn), 0, 70);
            addSprite(generateGraph(Circular.easeInOut), 70, 70);
            addSprite(generateGraph(Circular.easeOut), 140, 70);
            
            addSprite(generateGraph(Cubic.easeIn), 210, 70);
            addSprite(generateGraph(Cubic.easeInOut), 280, 70);
            addSprite(generateGraph(Cubic.easeOut), 350, 70);
            
            addSprite(generateGraph(Elastic.easeIn), 0, 140);
            addSprite(generateGraph(Elastic.easeInOut), 70, 140);
            addSprite(generateGraph(Elastic.easeOut), 140, 140);
            
            addSprite(generateGraph(Exponential.easeIn), 210, 140);
            addSprite(generateGraph(Exponential.easeInOut), 280, 140);
            addSprite(generateGraph(Exponential.easeOut), 350, 140);
            
            addSprite(generateGraph(Quadratic.easeIn), 0, 210);
            addSprite(generateGraph(Quadratic.easeInOut), 70, 210);
            addSprite(generateGraph(Quadratic.easeOut), 140, 210);
            
            addSprite(generateGraph(Quartic.easeIn), 210, 210);
            addSprite(generateGraph(Quartic.easeInOut), 280, 210);
            addSprite(generateGraph(Quartic.easeOut), 350, 210);
            
            addSprite(generateGraph(Quintic.easeIn), 0, 280);
            addSprite(generateGraph(Quintic.easeInOut), 70, 280);
            addSprite(generateGraph(Quintic.easeOut), 140, 280);
            
            addSprite(generateGraph(Sine.easeIn), 210, 280);
            addSprite(generateGraph(Sine.easeInOut), 280, 280);
            addSprite(generateGraph(Sine.easeOut), 350, 280);
            
            addSprite(generateGraph(Linear.easeIn), 0, 350);
            addSprite(generateGraph(Linear.easeInOut), 70, 350);
            addSprite(generateGraph(Linear.easeOut), 140, 350);
            addSprite(generateGraph(Linear.easeNone), 210, 350);
        }
        
        private function generateGraph(ease:Function):Sprite{
            var time:Number = 2;
            var wide:Number = 1;
            var width:Number = 70;
            var size:Number = 70;
            var insize:Number = size * 0.8;
            var outsize:Number = size * 0.1;
            var graph:Sprite = new Sprite();
            graph.graphics.lineStyle(1, 0x5050e0);
            graph.graphics.moveTo(0, insize);
            var dummy:Sprite = new Sprite();
            var tl:TweensyTimeline = Tweensy.fromTo(dummy, {y:0}, {y:insize}, time, ease);
            var frame:Number = 0;
            dummy.addEventListener(Event.ENTER_FRAME, function(e:Event):void{
                if(tl.finished){
                    dummy.removeEventListener(e.type, arguments.callee);
                    return;
                }
                graph.graphics.lineTo(frame++ * wide, insize - dummy.y);
            });
            var grapharea:Sprite = new Sprite();
            grapharea.addChild(graph);
            grapharea.graphics.lineStyle(1, 0xa0a0a0);
            grapharea.graphics.moveTo(0, outsize);
            grapharea.graphics.lineTo(width, outsize);
            grapharea.graphics.moveTo(0, size - outsize);
            grapharea.graphics.lineTo(width, size - outsize);
            graph.y = outsize;
            return grapharea;
        }
        
        private function addSprite(sprite:Sprite, x:Number, y:Number):void{
            addChild(sprite);
            sprite.x = x;
            sprite.y = y;
        }
    }
}