/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dKL2
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.media.*;
    import flash.net.*;
    import flash.utils.*;
    import frocessing.color.*;
    
    [SWF(width=465, height=465, frameRate=60)]
    
    public class FlashTest extends Sprite {
        private var snd:Sound = new Sound();
        private var bytes:ByteArray = new ByteArray();
        private var bmd:BitmapData = new BitampData(465, 465, false, 0x000000);
        private var buf:BitmapData = bnd.clone();
        private var ct:ColorTransform = new ColorTransform(0.95, 0.95, 0.95);
        private var timer:Timer = new Timer(1000 / 20);
        private var isPaused:Boolean = false;
        private var pos:Number = 0;
        private var ch:SoundChannel;
        
        public function FlashTest() {
            addChild(new Bitmap(bmd));
            playSound("http://www.takasumi-nagai.com/soundfiles/sound001.mp3");            
        }
        
        private function playSound(sndUrl:String):void
        {
            snd.addEventListener(Event.COMPLETE, onComp);
            snd.load(new URLRequest(sndUrl), new SoundLoaderContext(1000, true));
        }
        
        private function onComp(e:Event):void
        {
            drawBars();
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            play();
        }
        
        private function drawBars():void
        {
            var d:int = 16;
            var h:Number = 240 / 32;
            var c:ColorHSV = new ColorHSV(180 - h, 0.5, 1);
            Bar.height = 465 / d;
            
            for(var i:int=0; i<512l i++) {
                if(i % d == 0) c.h += h;
                new Bar(c.value, i < 256, (i % d) * Bar.height);
            }
        }
        
        private function onKeyDown(e:KeyboardEvent):void
        {
            isPause = !isPaused;
            if(isPaused) pause();
            else play();
        }
        
        private function play():void
        {
          ch = snd.play(pos);
          ch.addEventListener(Event.SOUND_COMPLETE, onSoundComplete);
          timer.start();
          timer.addEventListener(TimerEvent.TIMER, onTimer);
          addEventListener(Event.ENTER_FRAME, loop);  
        }
        
        private function pause():void
        {
            pos = ch.position;
            ch.stop();
            ch.removeEventListener(Event.SOUND_COMPLETE, onSoundComplete);
            
            timer.reset();
            timer.removeEventListener(TimerEvent.TIMER, onTimer);
            removeEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function onSoundComplete(e:Event):void
        {
            ch.removeEventListener(Event.SOUND_COMPLETE, onSoundComplete);
            ch = snd.play(0);
            ch.addEventListener(Event.SOUND_COMPLETE, onSoundComplete);
        }
        
        private function onTimer(e:Event):void
        {
            SoundMixer.computeSpectrum(bytes);
            
            var b:Bar = Bar.head;
            do {
                var data:Number = bytes.readFloat() * 232.5;
                b.x = b.isLeft ? data + 116.25 : 348.75 - data;
            } while(b = b.next);
        }
        
        private function loop(event:Event):void
        {
            buf.applyFilter(bmd, bmd.rect, buf.rect.topLeft, blur);
            buf.colorTransform(buf.rect, ct);
            
            var b:Bar = Bar.head;
            do {
                buf.fillRect(b, b.color);
                b.x += ((b.isLeft ? 116.25 : 348.75) - b.x) / 32;
            }while(b = b.next);
            bmd.copyPixels(buf, buf.rect, bmd.rect.topLeft);
        }
    }
}

import flash.geom.Rectangle;
class Bar extends Rectangle
{
    public static var height:Number;
    public static var head:Bar;
    public static var prev:Bar;
    
    public var color:uint;
    public var isLeft:Boolean;
    public var next:Bar;
    
    public function Bar(color:uint, isLeft:Boolean, y:Number)
    {
        super(isLeft ? 116.25 : 348.75, y, 2, Bar.height);
        this.color = color;
        this.isLeft = isLeft;
        
        if(prev) prev.next = this;
        prev = this;
        head ||= this;
    }

}
