/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dJMM
 */

package{
    import flash.utils.ByteArray;
    import flash.text.TextField;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.media.*;
    import flash.net.*;
    import frocessing.color.ColorHSV;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import frocessing.color.ColorHSV;
    import com.bit101.components.HUISlider;
    import com.bit101.components.Panel;
    import com.bit101.components.PushButton;
    
    public class Main extends Sprite
    {
        private var camera:Camera;
        private var video:Video;
        private var bd:BitmapData;

        private const WIDTH:int = 232;
        private const HEIGHT:int = 232;
        
        private var bitmapA:Bitmap;
        private var bitmapB:Bitmap;
        
        private var slider:HUISlider;
        private var slider2:HUISlider;

        //カメラ画像→BITMAPDATA→特徴点抽出

        private var btn:PushButton;
        private var btn2:PushButton;
        private var panel:Panel;
        private var tf:TextField = new TextField();
        private var s:Sprite = new Sprite();//選択カラー表示
        private var pixelCol:uint; //取得カラー
        
        private var file:FileReference = new FileReference();
 
        public function Main(){
            panel = new Panel(this);
            panel.width = panel.height = 465;
     
            btn = new PushButton(this,0,10,"WebCam ON");
            btn.x = 150;
            btn.y = 270;
            btn.addEventListener(MouseEvent.MOUSE_UP, startCamera);
            
            btn2 = new PushButton(this,0,10,"start");
            btn2.x = 250;
            btn2.y = 270;
            btn2.addEventListener(MouseEvent.MOUSE_UP, st);
            
            
            initHandler(null);
        }
        
        private var sw1:Boolean = false;
        private function st(e:MouseEvent):void{
            if(sw1==false){ 
                sw1=true;
                btn2.label="stop"
            }
            else{
                sw1=false;
                btn2.label="start";
            }
        }

        

        private function startCamera(e:MouseEvent):void{
            camera = Camera.getCamera();

            if ( camera == null ) {
            } else {
                start();
            }
            
        }

        
        private function start():void {
            camera.setMode(WIDTH,HEIGHT, 60);//カメラ設定 width, height, frame
            video = new Video(WIDTH,HEIGHT);//ビデオサイズ width, height
            video.attachCamera(camera);
            bd = new BitmapData(video.width, video.height);//ビデオサイズのビットマップデータ
            //this.addChild( video );
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        
        private function col(c1:uint,c2:uint):Number{
            
            var colorA:ColorHSV = new ColorHSV();
            var colorB:ColorHSV = new ColorHSV();
            colorA.value = c1;//基準色
            colorB.value = c2;//ピクセルの色取得
                    
            var r:int = colorA.r - colorB.r;//赤成分
            var g:int = colorA.g - colorB.g;//緑成分
            var b:int = colorA.b - colorB.b;//青成分
            
            return Math.sqrt(r * r + g * g + b * b);        
            
        }

       
       //コーナー検出
       private function check1(dat:BitmapData,x:int,y:int,val:int=50):Boolean{
           var size:int = 2;
           if(x-size<0)return false;
           if(y-size<0)return false;
           var px:Array = new Array();
           var cnt:int=0;
           //中心色
           var p1:uint = dat.getPixel(x,y);
           //中心と四方を比較
           var l:uint = dat.getPixel(x-1,y);
           if(col(p1,l)<val)cnt++;
           var r:uint = dat.getPixel(x+1,y);
           if(col(p1,r)<val)cnt++;
           var t:uint = dat.getPixel(x,y-1);
           if(col(p1,t)<val)cnt++;
           var b:uint = dat.getPixel(x,y+1);
           if(col(p1,b)<val)cnt++;
           
           if(cnt == 0 || 2 < cnt)return false;
           else return true;
                      
           
       }

       
        //毎フレーム処理
        private var cnt:uint=0;
        private var cnt2:uint=0;
        private var val:int = 50;
        private function onEnterFrame(e:Event):void {
            
            bd.lock();
            bd.draw(video);//ビデオデータ取得
        
            bd.unlock();           
            bitmapA.bitmapData = bd;
            bitmapB.bitmapData = bd;
            var cnt:int=0;
            var bd2:BitmapData = new BitmapData(bd.width,bd.height);
            var dat:ByteArray = new ByteArray();
            
            for(var i:int=0;i<bd.height;i++){//y
                for(var j:int=0;j<bd.width;j++){//x
                    bd2.setPixel(j,i,bd.getPixel(j,i));
                    if(Math.random()<0.1){
                        if(check1(bd,j,i,val)){ 
                            bd2.setPixel(j,i,0x00ff00);
                            cnt++;
                        }
                    }
                }
            }
            tf.text = cnt.toString();
            //if(59<val && 20<cnt)val-=10;
            //if(cnt<20)val+=10;
            
            bitmapB.bitmapData = bd2;

            var num:Number = Math.random();
            if(num<0.1)num = 0.1;
            //num = 0.2;
            var bm2:BitmapData = resize(bd,num,num);
            //bitmapB.bitmapData = resize(bm2,1/num,1/num);
            
            
        }
        
        public function resize(src:BitmapData, hRatio:Number, vRatio:Number):BitmapData{
            var res:BitmapData = new BitmapData(
                Math.ceil(src.width * hRatio), Math.ceil(src.height * vRatio)
            );
          res.draw(src, new Matrix(hRatio, 0, 0, vRatio), null, null, null, true);
          return res;
          }
 
        private function initHandler(event:Event):void{

 
            bd = new BitmapData(WIDTH, HEIGHT);
            //bd.draw(loader, matrix);
            
            bitmapA = new Bitmap(bd);
            panel.content.addChild(bitmapA);
            var destbd:BitmapData = bd.clone();
            bitmapB = new Bitmap(destbd);
            bitmapB.x = WIDTH ;
            panel.content.addChild(bitmapB);
            panel.content.addChild(tf);

            
        }

       

 
        
        
    }
}

