/**
 * Copyright _shimabox ( http://wonderfl.net/user/_shimabox )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dIly
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	import net.hires.debug.Stats;
	
	/**
	 * ...
	 * 重いです
	 * @author _s
	 */
	[SWF(width="465", height="465", frameRate="30",backgroundColor="0x000000")]
	public class Spire extends Sprite 
	{
		private const MOVE_TO:int = 1;
		private const COURVE_TO:int = 2;
		private const LINE_TO:int = 3;
		private const PI4_TAN:Number = Math.PI / 8;
		private const PI4_SIN:Number = Math.PI / 4;
		private const START_COLOR:uint = 0xff0000;
		private const COLOR_DIFF:int = 85;
		private var _x:Number;
		private var _y:Number;
		private var commands:Array = [];
		private var data:Array = [];
		private var dataCnt:int;
		private var s:Sprite = new Sprite();
		private var g:Graphics;
		private var timer:Timer;
		private var lineColor:uint;
		private var lineEndX:Number = 0;
		private var canvas:BitmapData;
		private var sp:Number = 0;
		private var bf:BlurFilter = new BlurFilter(2, 2, 1);
		private var ct:ColorTransform = new ColorTransform(1, 1, 1, 1, 0, 0, 0, -1);
		private var p:Point = new Point();
		private var isFirst:Boolean = true;
		private var colorChangeVal:int = 0;
		
		public function Spire():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			var sw:Number = this.stage.stageWidth
			var sh:Number = this.stage.stageHeight;
			this._x = sw / 2;
			this._y = sh / 2;
			this.canvas = new BitmapData(sw,  sh, true, 0xffffff);  
			this.addChild(new Bitmap(this.canvas, "auto", true));
			this.s.filters = [this.bf];
			this.g = this.s.graphics;
			this.addPushCoordinatesTimer();
			//this.addChild(new Stats());
			this.addEventListener(Event.ENTER_FRAME, enterFlameHandler);
			Wonderfl.capture_delay( 5 );
		}
		
		private function enterFlameHandler(e:Event):void 
		{
			this.canvas.lock();
			this.canvas.colorTransform(this.canvas.rect, this.ct);
			this.sp += 0.01 * Math.PI;
			var a:Number = 1 * Math.sin(this.sp);
			var b:Number = 0.5 * Math.cos(this.sp);
			var mat:Matrix = new Matrix(a, b, 0, 1, this._x, 0);
			this.canvas.draw(this.s, mat);
            this.canvas.unlock();
		}
		
		private function addPushCoordinatesTimer():void
		{
			this.timer = new Timer(1, 1);
			this.timer.start();
			this.timer.addEventListener(TimerEvent.TIMER, pushCoordinatesHandler);
			this.timer.addEventListener(TimerEvent.TIMER_COMPLETE, pushCoordinatesCompleteHandler);
		}
		
		private function pushCoordinatesHandler(e:TimerEvent):void 
		{
			var r:Number = Math.random() * 5 >> 0;
			r = r > 0 ? r : 1;
			
			this.lineColor  = this.getColor();
			this.setLineStyle(this.g);
			
			while ((this.lineEndX <= this.stage.stageWidth-100)){
				this.pushCoordinates(this._x, this._y, r)
				r += r;
			}
			
		}
		
		private function pushCoordinatesCompleteHandler(e:TimerEvent):void 
		{
			this.removePushCoordinatesTimer();
			this.addDrawTimer();
		}
		
		private function pushCoordinates(x:Number, y:Number, r:Number):void
		{
			//_commandsと_dataは対で格納
			//top
			this.commands.push(MOVE_TO);
			this.data[this.dataCnt++] = [x - r, y]; 
			this.commands.push(COURVE_TO);
			this.data[this.dataCnt++] = [x-r, -Math.tan(PI4_TAN)*r+y, -Math.sin(PI4_SIN)*r+x, -Math.sin(PI4_SIN)*r+y];
			this.commands.push(COURVE_TO);
			this.data[this.dataCnt++] = [-Math.tan(PI4_TAN) * r + x, -r + y, x, -r + y];
			this.commands.push(COURVE_TO);
			this.data[this.dataCnt++] = [Math.tan(PI4_TAN)*r+x, -r+y, Math.sin(PI4_SIN)*r+x, -Math.sin(PI4_SIN)*r+y];
			this.commands.push(COURVE_TO);
			this.data[this.dataCnt++] = [r + x, -Math.tan(PI4_TAN) * r + y, r + x, y];
			
			this.lineEndX = r + x;
			
			x -= r / 2;
			r += r / 2;
			
			//bottom
			this.commands.push(COURVE_TO);
			this.data[this.dataCnt++] = [r+x, Math.tan(PI4_TAN)*r+y, Math.sin(PI4_SIN)*r+x, Math.sin(PI4_SIN)*r+y];
			this.commands.push(COURVE_TO);
			this.data[this.dataCnt++] = [Math.tan(PI4_TAN)*r+x,r+y, x, r+y];
			this.commands.push(COURVE_TO);
			this.data[this.dataCnt++] = [-Math.tan(PI4_TAN)*r+x, r+y,-Math.sin(PI4_SIN)*r+x, Math.sin(PI4_SIN)*r+y];
			this.commands.push(COURVE_TO);
			this.data[this.dataCnt++] = [ -r + x, Math.tan(PI4_TAN) * r + y, -r + x, y];
		}
		
		private function addDrawTimer(isReverse:Boolean=false):void
		{
			var n:int = this.commands.length;
			this.timer = new Timer(20, n);
			this.timer.start();
			
			if(!isReverse){
				this.timer.addEventListener(TimerEvent.TIMER, drawHandler);
				this.timer.addEventListener(TimerEvent.TIMER_COMPLETE, drawCompleteHandler);
			}else {
				this.timer.addEventListener(TimerEvent.TIMER, drawReverseHandler);
				this.timer.addEventListener(TimerEvent.TIMER_COMPLETE, drawReverseCompleteHandler);
			}
		}
		
		private function drawHandler(e:TimerEvent):void
		{
			var t:Timer = e.currentTarget as Timer;
			var cnt:int = t.currentCount - 1;
			this.draw(this.g, this.commands[cnt], this.data[cnt]);
		}
		
		private function drawCompleteHandler(e:TimerEvent):void
		{
			var t:Timer = e.currentTarget as Timer;
			var cnt:int = t.currentCount;
			var len:int = this.commands.length;
			
			if(cnt == len){
				this.removeDrawTimer();
				this.addDrawTimer(true);
			}
		}
		
		private function drawReverseHandler(e:TimerEvent):void
		{
			var t:Timer = e.currentTarget as Timer;
			var cnt:int = t.currentCount;
			var len:int = this.commands.length - cnt;
			var g:Graphics = this.g;
			this.setLineStyle(g);
			for (var i:int = 0; i < len; i++) {
				this.draw(g,this.commands[i], this.data[i]);
			}
		}
		
		private function drawReverseCompleteHandler(e:TimerEvent):void
		{
			var t:Timer = e.currentTarget as Timer;
			var cnt:int = t.currentCount;
			var len:int = this.commands.length;
			
			if(cnt == len){
				this.removeDrawReverseTimer();
				this.clear();
				this.addPushCoordinatesTimer();
			}
		}
		
		private function draw(g:Graphics,command:int,data:Array):void
		{
			switch(command) {
				case MOVE_TO:
					g.moveTo(data[0],data[1]);
					break;
				case COURVE_TO:
					g.curveTo(data[0],data[1],data[2],data[3]);
					break;
				case LINE_TO:
					g.lineTo(data[0],data[1]);
					break;
			}
		}
		
		private function setLineStyle(g:Graphics):void
		{
			g.clear();
			g.lineStyle(2, this.lineColor, 1);
		}
		
		private function setColorLine(g:Graphics):void
		{
			g.lineStyle(2, this.getColor(), 1);
		}
		
		private function getColor():uint
		{
			var rs:String, gs:String, bs:String;
			var red:uint, green:uint, blue:uint;
			var changeVal:int = this.colorChangeVal;
			var color:uint;
			
			if (this.isFirst) {
				color = START_COLOR;
				red   = ( color & 0xff0000 ) >> 16;
				green = ( color & 0xff00 ) >> 8;
				blue  = ( color & 0xff );
				this.isFirst = false;
			}else {
				color = this.lineColor;
				red   = ( color & 0xff0000 ) >> 16;
				green = ( color & 0xff00 ) >> 8;
				blue  = ( color & 0xff );
			}
			
			switch(true) {
				case (changeVal == 1 || changeVal == 2 || changeVal == 3) : 
					green += COLOR_DIFF; 
					break;
				case (changeVal == 4 || changeVal == 5 || changeVal == 6) : 
					red -= COLOR_DIFF;
					break;
				case (changeVal == 7 || changeVal == 8 || changeVal == 9) : 
					blue += COLOR_DIFF;
					break;
				case (changeVal == 10 || changeVal == 11 || changeVal == 12) :
					green -= COLOR_DIFF;
					break;
				case (changeVal == 13 || changeVal == 14 || changeVal == 15):
					red += COLOR_DIFF;
					break;
				case (changeVal == 16 || changeVal == 17): 
					blue -= COLOR_DIFF;
					break;
				case (changeVal == 18) :
					blue -= COLOR_DIFF;
					this.colorChangeVal = 0;
					this.isFirst = true;
					break;
			}
			
			rs = (red > 0)   ? (red).toString(16)   : '0' + (red).toString(16);
			gs = (green > 0) ? (green).toString(16) : '0' + (green).toString(16);
			bs = (blue > 0)  ? (blue).toString(16)  : '0' + (blue).toString(16);
			
			this.colorChangeVal++;
			return uint('0x' + rs + gs + bs);
		}
		
		private function removePushCoordinatesTimer():void 
		{
			this.timer.removeEventListener(TimerEvent.TIMER, pushCoordinatesHandler);
			this.timer.removeEventListener(TimerEvent.TIMER_COMPLETE, pushCoordinatesCompleteHandler);
			this.timer = null;
		}
		
		private function removeDrawTimer():void 
		{
			this.timer.removeEventListener(TimerEvent.TIMER, drawHandler);
			this.timer.removeEventListener(TimerEvent.TIMER_COMPLETE, drawCompleteHandler);
			this.timer = null;
		}
		
		private function removeDrawReverseTimer():void 
		{
			this.timer.removeEventListener(TimerEvent.TIMER, drawReverseHandler);
			this.timer.removeEventListener(TimerEvent.TIMER_COMPLETE, drawReverseCompleteHandler);
			this.timer = null;
		}
		
		private function clear():void
		{
			this.g.clear();
			this.lineEndX = this.dataCnt = 0;
			this.commands = [];
			this.data     = [];
		}
	}
}