/**
 * Copyright telcanty ( http://wonderfl.net/user/telcanty )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dHeB
 */

// forked from telcanty's forked from: flash on 2009-9-22
// forked from andrew_croce's flash on 2009-9-22
package {
    import flash.display.Sprite;
    import flash.events.*;
    
    public class FlashTest extends Sprite {
        private var ball:Sprite = new Sprite();
        private var size:Number = 30;
	private var speed:Number = 10;
	private var accel:Number = .97;
	private var max:Number = 50;
	private var min:Number = -50;
		
	//distance between point clicked and center of ball
        private var xoffset:Number = new Number();
	private var yoffset:Number = new Number();
		
	private var xvel:Number = new Number();
	private var yvel:Number = new Number();
	private var xaccel:Number = accel;
	private var yaccel:Number = accel;
		
	//to record dragged ball positions
	private var xpath:Array = new Array();
	private var ypath:Array = new Array();
		
        
        public function FlashTest():void {
            // write as3 code here..
            drawBall();
	    ball.addEventListener(MouseEvent.MOUSE_DOWN,_startDrag);
	    ball.addEventListener(MouseEvent.MOUSE_UP,_release);
            
        }
        private function drawBall():void
		{
			ball.graphics.beginFill(0x990077,1);
                            ball.graphics.lineStyle(1, 0xFF0000,1);
                            ball.graphics.moveTo(0,0);
                            ball.graphics.lineTo((stage.stageWidth/2)-(size/2),(stage.stageHeight/2)-(size/2));
			ball.graphics.drawCircle((stage.stageWidth/2)-(size/2),(stage.stageHeight/2)-(size/2),size/2);
                            ball.graphics.endFill();
                            ball.graphics.beginFill(0x00FF00);			
                            ball.graphics.drawCircle(0,0,10);
                            ball.graphics.endFill();
			this.stage.addChild(ball);
		}
		
		private function _startDrag(e:MouseEvent = void):void
		{
			
			xoffset = e.stageX - ball.x;
			yoffset = e.stageY - ball.y;
			
			this.stage.addEventListener(MouseEvent.MOUSE_MOVE,_drag);
		}
		
		private function _drag(e:MouseEvent = void):void
		{
			//set ball position to event(mouse) position
			ball.x = e.stageX - xoffset;
			ball.y = e.stageY - yoffset;
			e.updateAfterEvent();
			ball.addEventListener(Event.ENTER_FRAME,_dragUpdate);
		}
		
		private function _release(e:MouseEvent = void):void
		{
			this.stage.removeEventListener(MouseEvent.MOUSE_MOVE, _drag);
			throwBall();
		}
		
		private function _dragUpdate(e:Event = void):void
		{
			//add new ball position to end of array, and drop the first position
			xpath.push(ball.x);
			if (xpath.length >= 5)
			{
				xpath = xpath.slice(1,5);
			}
			ypath.push(ball.y);
			if (ypath.length >= 5)
			{
				ypath = ypath.slice(1,5);
			}
			//trace("X "+ xpath);
			//trace("Y "+ ypath);
			
		}
		
		private function throwBall():void
		{
			//calculate velocity based on last two values in path arrays
			xvel = xpath[3] - xpath[2];
			yvel = ypath[3] - ypath[2];
			
			if (xvel > max)
			{
				xvel = max;
			} else
			{
				if (xvel < min)
				{
					xvel = min;
				}
			}
			
			if (yvel > max)
			{
				yvel = max;
			} else
			{
				if (yvel < min)
				{
					yvel = min;
				}
			}
			
			this.stage.addEventListener(Event.ENTER_FRAME,_throwUpdate);
		}
		
		private function _throwUpdate(e:Event = void):void
		{
			if (((ball.x) + stage.stageWidth/2) >= stage.stageWidth)
			{
				xvel *= -1;
			} else
			{
				if (((ball.x - size) + stage.stageWidth/2) <= 0)
				{
					xvel *= -1;
				}
			}
			
			if (((ball.y) + stage.stageHeight/2) >= stage.stageHeight)
			{
				yvel *= -1;
			} else
			{
				if (((ball.y - size) + stage.stageHeight/2) <= 0)
				{
					yvel *= -1;
				}
			}
			
			if (((xvel + yvel) < .4) && ((xvel + yvel) > -.4))
			{
				xvel = 0;
				yvel = 0;
			}
		
			xvel *= accel;
			yvel *= accel;
			ball.x += xvel;
			ball.y += yvel;
			
			if (xvel == 0)
			{
				this.stage.removeEventListener(Event.ENTER_FRAME,_throwUpdate);
			}
		}

    }
}