/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dHZQ
 */

// forked from itsDcTurner's forked from: Random Caverns (with depth)
// forked from itsDcTurner's Random Caverns
// forked from itsDcTurner's Pattern Experiment 1
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import gs.OverwriteManager;
    
    [SWF(backgroundColor="#000000", frameRate=60)]
    public class Main extends Sprite 
    {
        private const     patternBank:Array = [new<int>[1,1,1,0,0,0,1,1,1],  new<int>[1,0,1,1,0,1,1,0,1], new<int>[1,1,1,1,0,1,0,0,0], new<int>[0,0,0,1,0,1,1,1,1]];
        private var     cellWidth:Number;
        private var     blockColour:uint;
        private var     halfStage:Number;
        
        private const rotateRangeX:Number = 40;
        private const rotateRangeY:Number = 40;
        private const cameraSpeed:int = 10;
        
        private var container:Sprite;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            OverwriteManager.init(OverwriteManager.AUTO);
            halfStage = stage.stageWidth *.5;
            
            container = new Sprite();
            addChild(container);
            
            container.x += halfStage;
            container.y += halfStage;
            container.z = 50;
            
            draw(1, 0x222222, 140);
            draw(2, 0x444444, 110);
            draw(4, 0x666666, 80);
            draw(8, 0xeeeeee, 50, true);
            
            addEventListener(Event.ENTER_FRAME, render);
     
        }
        
        private function render(e:Event):void{
            var destX:Number = -rotateRangeX + (mouseX / halfStage)*(rotateRangeX);
            container.rotationY += (destX - container.rotationY)/cameraSpeed;
            
            var destY:Number = -rotateRangeY + (mouseY / halfStage)*(rotateRangeY);
            container.rotationX += (destY - container.rotationX)/cameraSpeed;
        }

        
        private function draw($gridSize:int, $col:uint, $z:Number, $isFrontRow:Boolean = false):void
        {
            blockColour = $col;
            cellWidth = stage.stageWidth / $gridSize;
            var loc:Point = new Point(0, 0);
            var count:int = 0;
            
            for (var  i:int =  0;  i  < $gridSize;  i ++) 
            {
                for (var j:int =  0; j  < $gridSize; j ++) 
                {
                    loc.x = ((i * cellWidth) + cellWidth *.5)-halfStage;
                    loc.y = ((j * cellWidth) + cellWidth *.5)-halfStage;
                    addPattern(loc, count, $z, $isFrontRow);
                    count++;
                }
            }
        }
        private function addPattern($loc:Point, $index:int, $z:Number, $isFrontRow:Boolean = false):Pattern {
            var p:Pattern = new Pattern(cellWidth, patternBank[int(Math.random() * patternBank.length)], blockColour, $index, $isFrontRow);
            p.x = $loc.x;
            p.y = $loc.y;
            p.z = $z;
            container.addChild(p);
            return p;
        }
    }
}
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import flash.geom.Point;
    import gs.TweenMax;
    import gs.easing.*;
    
    class Pattern extends Sprite {
        
        private const minTime:Number = .35;
        private const maxTime:Number = 2;
        private const activeColour    :uint = 0xdd0000;
        private const highlightColour :uint = 0xbbddff;
        private var inactiveColour  :uint;
        private var isActive:Boolean = false;
        
        public var v        :Vector.<int>;
        public var size        :Number;
        public var gridSize    :int;
        public var col        :uint;
        private var cellSize:Number;
        private var halfSize:Number;
        
        function Pattern($size:Number, $pat:Vector.<int>, $col:uint, index:int, $isFrontRow:Boolean = false):void {
            
            if ($isFrontRow)setupButton();
            
            v = $pat;
            trace(v);
            inactiveColour = $col
            size = $size;
            gridSize = Math.sqrt(v.length);
            drawPattern();
            TweenMax.delayedCall(Math.random()*30, rotate);
     
            alpha=0;
            TweenMax.to(this, Math.random()*15, {alpha:100, ease:Bounce.easeOut, delay:index*.04});
        }
        
        private function setupButton():void{
             buttonMode = true;
             
            addEventListener(MouseEvent.CLICK, clickHandler);
            addEventListener(MouseEvent.MOUSE_OVER, overHandler);
            addEventListener(MouseEvent.MOUSE_OUT, outHandler);
        }
        
        private function clickHandler(e:MouseEvent):void{
            isActive = (isActive) ? false : true; // toggle active on click
            TweenMax.to(this, .5, {tint:getTargetColour()});
        }
        
        private function overHandler(e:MouseEvent):void{
            TweenMax.to(this, .2, {tint:highlightColour, scaleX:.8, scaleY:.8, ease:Expo.easeOut});
        }
        
        private function outHandler(e:MouseEvent):void{
            var targetColour:uint = getTargetColour();
            TweenMax.to(this, 2, {tint:targetColour, scaleX:1, scaleY:1, ease:Expo.easeOut});
        }
        
        private function getTargetColour():uint{
            return (isActive) ? activeColour : inactiveColour;
        }


        
        private function rotate():void
        {
            var rotAmount:int = int((Math.random() * 6)-3) * 90;
            var time:Number = randomBetween(minTime, maxTime);
            
            TweenMax.to(this, time, { rotation:rotAmount, ease:Bounce.easeOut } );
            TweenMax.delayedCall(Math.random()*25, rotate);
            
        }
        
        private function randomBetween($min:Number, $max:Number):Number {
            return minTime + Math.random() * ($max - $min);
        }
        
        private function drawPattern():void
        {
            var count:int = 0;
            var loc:Point = new Point(0, 0);
            graphics.beginFill(inactiveColour);
            cellSize = size / gridSize;
            halfSize = size * .5;
            
            trace("cellsize: " + cellSize);
            
            for (var i:int = 0; i < gridSize; i++) 
            {
                for (var j:int = 0; j < gridSize; j++) 
                {
                    trace("i: " + i +", j: " + j +", = :" + v[count]);
                    if (v[count]) {
                        loc.x = (i * cellSize); 
                        loc.y = (j*cellSize);
                        addSquare(loc);
                    }
                    count++;
                }
            }
            graphics.beginFill(0x00ff00,0);
            graphics.drawRect(-halfSize, -halfSize, size, size);
            graphics.endFill();
        }
        private function addSquare($loc:Point):void {
            graphics.beginFill(inactiveColour);
            graphics.drawRect($loc.x-halfSize, $loc.y-halfSize, cellSize, cellSize);
            graphics.endFill();
            trace("square at " + $loc.x + ", " + $loc.y);
        }
    }