/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dGqx
 */

package {
    import Box2D.Common.Math.b2Vec2;
    import com.actionsnippet.qbox.objects.CircleObject;
    import com.actionsnippet.qbox.QuickBox2D;
    import flash.display.BlendMode;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    
    [SWF(backgroundColor="0xffffff",width=465,height=465,frameRate=60)]
    public class FlashTest extends Sprite {
        private var _qbox:QuickBox2D;
        private var _softbody:Array = [];
        public function FlashTest() {
            if(stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);            
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            stage.quality = StageQuality.LOW;
            
            var mc:MovieClip = new MovieClip();
            addChild(mc);
            
            _qbox = new QuickBox2D(mc);
            _qbox.setDefault({lineAlpha:0, fillColor:0});
            
            _qbox.createStageWalls();
            _qbox.mouseDrag();
            _qbox.start();
            
            _qbox.addBox({x:10, y:1, width:1, height:1});
            _qbox.addBox({x:12, y:1, width:2, height:2});
            
            _qbox.setDefault({lineAlpha:0, fillAlpha:0});
            
            for(var i:int=0; i<2; i++)
            {
                _softbody[i] = new SoftBody(_qbox, {x:i*3+4,y:7,lineAlpha:0,fillColor:0xffffff*Math.random(), radius:i+1});
                addChild(_softbody[i]);
            }
            
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void
        {
            for each(var sb:SoftBody in _softbody)
            {
                sb.update();
            }
        }
    }
}

import flash.display.Sprite;
import Box2D.Common.Math.b2Vec2;
import com.actionsnippet.qbox.QuickBox2D;
import com.actionsnippet.qbox.objects.CircleObject;
import com.actionsnippet.qbox.QuickObject;

class Anchor extends CircleObject
{
    private var vx:Number = 0;
    private var vy:Number = 0;
    private var spring:Number = 2;
    private var friction:Numbere = 0.1;
    private var vec:b2Vec2;
    private var target:QuickObject;
    private var rot:Number;
    
    public function Anchor(qbox:QuickBox2D, params:Object, target:QuickObject = null, rot:Number = 0)
    {
        super(qbox, params);
        this.target = target;
        this.rot = rot;
        vec = new b2Vec2();
    }
    
    public function update():void
    {
        if(!target) return;
        var targetPos:b2Vec2 = target.body.GetPosition();
        var thisPos:b2Vec2 = body.GetPosition();
        var dx:Number = Math.sin(rot * Math.PI / 180) * 2 + targetPos.x - thisPos.x;
        var dy:Number = Math.cos(rot * Math.PI / 180) * 2 + targetPos.y - thisPos.y;
        var ax:Number = dx * spring;
        var ay:Number = dy * spring;
        vx += ax;
        vy += ay;
        vec.x = vx;
        vec.y = vy;
        body.ApplyForce(vec, thisPos);
        vx *= friction;
        vy *= friction;
    }
}

class SoftBody extends Sprite
{
    public var params:Object;
    private var _anchor:Array = [];
    private var qbox:QuickBox2D;
    
    public function SoftBody(qbox:QuickBox2D, params:Object)
    {
        this.params = params;
        this.qbox = qbox;
        if(this.params.lineColor == null) this.params.lineColor = 1;
        if(this.params.lineAlpha == null) this.params.lineAlpha = 1;
        if(this.params.fillColor == null) this.params.fillColor = 0;
        if(this.params.fillAlpha == null) this.params.fillAlpha = 1;
        if(this.params.radius == null) this.params.radius = 1;
        
        create();
    }
    
    private function create():void
    {
        var rot:Number = 0;
        for(var i:int=0; i<18; i++)
        {
           rot+=20;
           _anchor[i] = new Anchor(qbox, {x:Math.sin(rot * Math.PI / 180) * params.radius + params.x, y:Math.cos(rot*Math.PI/180) * params.radius + params.y, radius:0.1},_anchor[i-1], rot);
           _anchor[i].shape.m_radius = 0.1 * params.radius;
           if(i != 0) qbox.addJoint({type:QuickBox2D.DISTANCE, a:_anchor[_anchor.length-1].body}); 
        }
        
        public function update():void
        {
            graphics.clear();
            graphics.beginFill(params.fillColor, params.fillAlpha);
            graphics.lineStyle(1, params.lineColor, params.lineAlpha);
            graphics.moveTo(_anchor[1].x * 30, _anchor[1].y * 30);
            var len:uint = _anchor.length;
            for(var i:int=1; i<len; i++) {
                _anchor[i].update();
                graphics.lineTo(_anchor[i].x * 30, _anchor[i].y * 30);
            }
            graphics.lineTo(_anchor[1].x * 30, _anchor[1].y * 30);
        }
    }
}

