/**
 * Copyright djankey ( http://wonderfl.net/user/djankey )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dGba
 */

package 
{
    import flash.display.Sprite;
    import flash.display.BitmapData;  
    import flash.display.Loader;
    import flash.geom.Matrix;
    
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.IOErrorEvent;
    
    import flash.system.Security;
    import flash.net.URLRequest; 
    import flash.net.URLLoader;     
    
    import flash.display.Stage;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.StageDisplayState;
    
    import com.bit101.components.PushButton;
    import net.hires.debug.Stats;
    
    /**
     * ...
     * @author djankey
     */
    public class Main extends Sprite 
    {
        private var pattern_url           :String     = "http://farm2.static.flickr.com/1197/5116216816_39957c273e.jpg";
        private var patternMatrix         :Matrix        = new Matrix(); 
        private var patternSprite         :Sprite        = new Sprite();
        private var _patternBitmapData    :BitmapData;
        private var fbtn                  :PushButton;
    
        private var stage_w                :int;        
        private var stage_h                :int;        
        private var speed_x                :Number = 1;
        private var speed_y                :Number = 1;
        private var max_speed              :Number = 35;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        //________________________________________________________ init
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            stage.scaleMode     = StageScaleMode.NO_SCALE;
            stage.align         = StageAlign.TOP_LEFT;
            stage.addEventListener(Event.RESIZE, resizeHandler);
            stage.frameRate     = 60;
            
            stage_w = stage.stageWidth;
            stage_h = stage.stageHeight;
            
            Security.loadPolicyFile("http://farm2.static.flickr.com/crossdomain.xml");
                                   
            var loader : Loader = new Loader(); 
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComplete);  
            loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, loadError); 
            loader.load(new URLRequest(pattern_url));
        }
        
        //________________________________________________________ Resize
        private function resizeHandler (event:Event):void {
            stage_w = stage.stageWidth;
            stage_h = stage.stageHeight;
            
            fbtn.x = stage_w - fbtn.width - 5;
        }
        
        //________________________________________________________ Toggle fullscreen
        private function toggleFullscreen(event:MouseEvent):void
        {
            if (stage.displayState == StageDisplayState.NORMAL) {
                stage.displayState=StageDisplayState.FULL_SCREEN;
            } else {
                stage.displayState=StageDisplayState.NORMAL;
            }
        }
 
        
        //________________________________________________________ Image loading complete
        private function loadComplete(e:Event):void
        {
            _patternBitmapData = e.target.content.bitmapData;
            
            addChild(patternSprite);
            
            addChild(new Stats());
            
            fbtn = new PushButton(this, 0, 5, "Fullscreen");
            fbtn.x = stage_w - fbtn.width - 5;
            fbtn.addEventListener(MouseEvent.MOUSE_UP, toggleFullscreen);
            addChild(fbtn);
                        
            stage.addEventListener(Event.ENTER_FRAME, draw);        
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mousePosition);
        }
                
        //________________________________________________________ Image Error!
        private function loadError(e:IOErrorEvent):void 
        {
            trace("Image error!");
        }
            
        //________________________________________________________ Mouse position
        private function mousePosition(e:MouseEvent):void
        {
            speed_x = -((mouseX - stage_w * 0.5) / stage_w * 0.5) * max_speed;
            speed_y = -((mouseY - stage_h * 0.5) / stage_h * 0.5) * max_speed;
        }
        
        //_______________________________________________________ draw
        private function draw(e:Event):void
        {            
            patternMatrix.translate(speed_x, speed_y);
            patternSprite.graphics.clear();
            patternSprite.graphics.beginBitmapFill(_patternBitmapData, patternMatrix, true, false);
            patternSprite.graphics.drawRect(0, 0, stage_w, stage_h); 
            patternSprite.graphics.endFill(); 
        }    
    }
    
}