/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dGRT
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.ShaderFilter;
    import flash.net.*;
    import flash.system.LoaderContext;
    import mx.utils.*;

	public class FlashTest extends Sprite {

		public static const asShader:Vector.<String> = Vector.<String>([
	"pQEAAACkEgBDcm9zc1Byb2R1Y3RGaWx0ZXKgDG5hbWVzcGFjZQBBSUYAoAx2ZW5k",
	"b3IAQWRvYmUgU3lzdGVtcwCgCHZlcnNpb24AAgCgDGRlc2NyaXB0aW9uAGNyb3Nz",
	"IHByb2R1Y3QgZmlsdGVyAKEBAgAADF9PdXRDb29yZAChAQMBAA5hZGoAogNtaW5W",
	"YWx1ZQC/gAAAv4AAAL+AAACiA21heFZhbHVlAD+AAAA/gAAAP4AAAKIDZGVmYXVs",
	"dFZhbHVlAD+AAAA/gAAAP4AAAKMABHNyYwChAgQCAA9kc3QAMAMA8QAAEAAdBADz",
	"AwAbAB0DAOIEABgAMgAAIEAAAAAdBQDiAwAYAAMFAOIAAKgAMgYAgD+AAAAyBgBA",
	"P4AAADIGACA/gAAAHQcA4gUAGAACBwDiBgAYAB0DAOIHABgAHQUA4gMAGAAnBQDi",
	"AQAYAB0DAOIFABgAMgUAgD+AAAAyBQBAP4AAADIFACA/gAAAHQYA4gMAGAABBgDi",
	"BQAYADIAACA/AAAAHQUA4gYAGAADBQDiAACoAB0DAOIFABgAHQUAgAMAAAAdBQBA",
	"AwBAAB0FACADAIAAMgAAID+AAAAdBQAQAACAAB0CAPMFABsA"])

		public var filter:ShaderFilter, shader:Shader;
		public var fX:Number, fY:Number, fZ:Number;
		public var iMode:int;
		
		function FlashTest() {
			Make();
		}
		
		public function Make():void {

                   var loader :Loader = new Loader;
                   loader.load(new URLRequest(
                    'http://assets.wonderfl.net/images/related_images/c/cf/cf1f/cf1fd3623e30ac888f91916d71f4d02e72bc933b'),
                       new LoaderContext( true )
                   );
 
                    loader.contentLoaderInfo.addEventListener(
                        Event.COMPLETE, function(e :Event) :void {
                            var bd :BitmapData 
                            = new BitmapData(stage.stageWidth,stage.stageHeight);
                            var bitmap :Bitmap = new Bitmap( bd );
                            bd.draw( loader );
                            addChild( bitmap );
                        });


		
			var dec:Base64Decoder = new Base64Decoder;
			dec.decode(asShader.join(""));
			filter = new ShaderFilter(shader = new Shader(dec.drain()));
			stage.addEventListener(MouseEvent.MOUSE_MOVE, Move);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, Click);
			fX = fY = fZ = -1;
		}
		
		public function Move(ev:MouseEvent):void {
			
			fX = -1 + 2 * (ev.stageX / stage.stageWidth);
			fY = -1 + 2 * (ev.stageY / stage.stageHeight);
			
			switch (iMode) {
				case 0:
					shader.data.adj.value = [fX, fY, fZ];
					break;
				case 1:
					shader.data.adj.value = [fY, fZ, fX];
					break;
				case 2:
					shader.data.adj.value = [fZ, fX, fY];
					break;
			}
			filters = [filter];
		}

		public function Click(ev:MouseEvent):void {
			iMode = (iMode + 1) % 3;
			fZ = fY;
			Move(ev);
		}
	}
}

/*
<languageVersion: 1.0;>

// CrossProductFilter: A filter that uses a cross product.
kernel CrossProductFilter
<   namespace : "";
    vendor : "JWB Software";
    version : 2;
    description : "cross product filter"; >
{

    // a vector with all components between -1 and 1
    parameter float3 adj
    <
        minValue:float3(-1.0, -1.0, -1.0);
        maxValue:float3(1.0, 1.0, 1.0);
        defaultValue:float3(1.0, 1.0, 1.0);
    >;

    input image4 src;
    output float4 dst;
    
    // evaluatePixel(): The function of the filter that actually does the 
    //                  processing of the image.  This function is called once 
    //                  for each pixel of the output image.
    void
    evaluatePixel()
    {
        float4 col = sampleNearest(src, outCoord());

        float3 ortho = col.xyz;
        ortho = ortho * 2.0 - float3(1.0, 1.0, 1.0);
        ortho = cross(ortho, adj);
        ortho = (ortho + float3(1.0, 1.0, 1.0)) * 0.5;
        dst = float4(ortho.x, ortho.y, ortho.z, 1.0);
    }
}
*/
