/**
 * Copyright mmlemon_ ( http://wonderfl.net/user/mmlemon_ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dG8p
 */

/**
* 

*/
package
{
    import flash.events.KeyboardEvent;
    import flash.display.AVM1Movie;
    import flash.text.TextField;
    
    import flash.display.GraphicsPath;
    import flash.display.GraphicsSolidFill;
    import flash.display.GraphicsStroke;
    import flash.display.IGraphicsData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.ui.Keyboard;
    
    [SWF(backgroundColor=0xffffff,frameRate=60)]
    public class GraphicsSample extends Sprite
    {
        
        private var m_currentShape:DrawLineShape;
        
        private var m_tf:TextField;
        
        public function GraphicsSample()
        {
            m_tf = new TextField();
            addChild(m_tf);
            addEventListener(Event.ADDED_TO_STAGE, init, false, 0, false);
        }
        
        private function init(event:Event=null):void
        {
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler, false, 0, false);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler, false, 0, false);
            m_tf.text = "a";
            stage.addEventListener(KeyboardEvent.KEY_DOWN, changeStrokeHandler, false, 0, false);
        }
        
        private function changeStrokeHandler(event:KeyboardEvent):void
        {
            switch(event.keyCode)
            {
                case Keyboard.UP:   
                    
                    break;
                case Keyboard.DOWN:
                    
                    break;
            }

        }
        
        private function changeStroke(_toStroke:int):void
        {
            
        }

        
        private function mouseDownHandler(event:MouseEvent):void
        {
            m_tf.text = "mouseDown";
            m_currentShape = new  DrawLineShape();
            addChild(m_currentShape);
            m_currentShape.x = event.stageX;
            m_currentShape.y = event.stageY;
            m_currentShape.graphicsStroke = new GraphicsStroke(4);
            m_currentShape.graphicsStroke.fill = new GraphicsSolidFill(0xff0000, 0.5);
            
            m_currentShape.graphicsPath = new GraphicsPath(new Vector.<int>(), new Vector.<Number>());
            m_currentShape.graphicsPath.moveTo(0, 0);
            
            var drawing:Vector.<IGraphicsData> = new Vector.<IGraphicsData>();
            drawing.push(m_currentShape.graphicsStroke, null, m_currentShape.graphicsPath);
            
            m_currentShape.graphics.drawGraphicsData(drawing);
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler, false, 0, false);
        }
        private function mouseMoveHandler(event:MouseEvent):void
        {
            m_tf.text = "mouseMove";
            m_currentShape.graphics.clear();
            m_currentShape.graphicsPath.lineTo(event.stageX-m_currentShape.x, event.stageY-m_currentShape.y);
            
            var drawing:Vector.<IGraphicsData> = new Vector.<IGraphicsData>();
            drawing.push(m_currentShape.graphicsStroke, null, m_currentShape.graphicsPath);
            
            m_currentShape.graphics.drawGraphicsData(drawing);
        }
        private function mouseUpHandler(event:MouseEvent):void
        {
            m_tf.text = "mouseUp";
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler, false);
        }
        
    }
}
import flash.display.GraphicsPath;
    import flash.display.GraphicsSolidFill;
    import flash.display.GraphicsStroke;
    import flash.display.Shape;

class DrawLineShape extends Shape
{
    
    /**
         * パス情報
         */
        public var graphicsPath:GraphicsPath;
        /**
         * 線のスタイル情報
         */
        public var graphicsStroke:GraphicsStroke;
        public var graphicsSolidFill:GraphicsSolidFill;
}

