/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dG1G
 */

package {
    import flash.display.*;
    import flash.net.*;
    import jp.progression.commands.lists.*;
    import jp.progression.commands.net.*;
    import jp.progression.data.*;
    import jp.progression.events.*;
    import flash.system.LoaderContext;
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var list:Array = [
                ResourceName.ORANGE,
                ResourceName.GREEN,
                ResourceName.YELLOW,
                ResourceName.BLUE,
                ResourceName.PURPLE
            ];
            
            var listLoader:LoaderList = new LoaderList();
            var loader:LoadCommand;
            var context:LoaderContext = new LoaderContext(true);
            for each( var url:String in list ) {
                loader  = new LoadBitmapData(new URLRequest(url), { group:"colors", cacheAsResource:true, context:context });
                listLoader.addCommand( loader );
            }
            listLoader.addEventListener( ExecuteEvent .EXECUTE_COMPLETE, onLoadedList );
            listLoader.execute();
        }
        private function onLoadedList (e:ExecuteEvent ) :void {
            e.target.addEventListener( e.type, onLoadedList );
            
            var resources:Array = getResourcesByGroup("colors");
            
            var prev:DisplayObject;
            for each( var r:Resource in resources ) {
                var disp:DisplayObject = addChild( new Bitmap( r.toBitmapData() ) );
                disp.x = prev ? ( prev.x + prev.width ): 0;
                prev = disp;
            }
        }
    }
}

class ResourceName {
    public static const ORANGE:String = "http://assets.wonderfl.net/images/related_images/9/94/9425/942571bd915c25edd87259fd667dda3e70fae467";
    public static const YELLOW:String = "http://assets.wonderfl.net/images/related_images/b/b1/b1a2/b1a2df97b08affc487af947006dbcfc6601ee732";
    public static const GREEN:String = "http://assets.wonderfl.net/images/related_images/b/be/be47/be47238a6d48a0cc0e69202c7f9f09d7f2a40a8f";
    public static const BLUE:String = "http://assets.wonderfl.net/images/related_images/f/f0/f0ce/f0ce819d7d0e2dbe1d797aa534ef34bb3d644617";
    public static const PURPLE:String = "http://assets.wonderfl.net/images/related_images/c/c2/c2a3/c2a3854064c3317e2e53867a32b678b8010648de";
}