/**
 * Copyright hacker_9p8x8mco ( http://wonderfl.net/user/hacker_9p8x8mco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dEtP
 */

package {
    import flash.display.Sprite;
    import flash.events.TimerEvent;
    import flash.events.MouseEvent;
    import flash.utils.Timer;
    public class FlashTest extends Sprite {
        private var xAcceleration:Number = 0;
        private var yAcceleration:Number = 0;
        private var xSpeed:Number = 10;
        private var ySpeed:Number = -10;
        private var opposition:Number = 0.8;
        private var drag:Number = 0.995;
        private var gravity:Number = 0.5;
        private var ball:Sprite;
        private var radius:Number = 20;
        private var beforeX:Number;
        private var beforeY:Number;
        private var timer:Timer;
        private var time:Number = 1000/60;
        private var isDrag:Boolean = false;
        public function FlashTest() {
            
            ball = new Sprite();
            ball.x = stage.stageWidth / 2;
            ball.y = stage.stageHeight / 2;
            ball.graphics.beginFill(0xFFFF0000);
            ball.graphics.drawCircle(0, 0, radius);
            
            ball.addEventListener(MouseEvent.MOUSE_DOWN,function(event:MouseEvent):void{
                isDrag = true;
            });
            
            ball.addEventListener(MouseEvent.MOUSE_UP,function(event:MouseEvent):void{
                isDrag = false;
            });
            
            addChild(ball);
            
            timer = new Timer(time);
            timer.addEventListener(TimerEvent.TIMER, function(event:TimerEvent):void{
                
                if(ball.x + radius > stage.stageWidth)
                {
                    ball.x = stage.stageWidth - radius;
                    xSpeed *= -opposition;
                }
                
                if(ball.x - radius < 0)
                {
                    ball.x = radius;
                    xSpeed *= -opposition;
                }
                
                if(ball.y + radius > stage.stageHeight)
                {
                    ball.y = stage.stageHeight - radius;
                    ySpeed *= -opposition;
                }
                
                if(ball.y - radius < 0)
                {
                    ball.y = radius;
                    ySpeed *= -opposition;
                }
                
                if(isDrag)
                {
                    xSpeed = mouseX - beforeX;
                    ySpeed = mouseY - beforeY;
                }
                else
                {
                    xSpeed = xSpeed * drag + xAcceleration;
                    ySpeed = ySpeed * drag + (yAcceleration + gravity);
                }
                
                ball.x += xSpeed;
                ball.y += ySpeed;
                
                beforeX = ball.x;
                beforeY = ball.y;
                
            });
            timer.start();
        }
    }
}