/**
 * Copyright ishiken ( http://wonderfl.net/user/ishiken )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dEsm
 */

package{
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFieldAutoSize;
    import frocessing.display.F5MovieClip2DBmp;
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    import flash.geom.Rectangle;
    public class Main extends F5MovieClip2DBmp{
        private var stageWidth:Number = stage.stageWidth;
        private var stageHeight:Number = stage.stageHeight;
        private var rectangleWidth:Number = stageWidth-(stageWidth/3-49);//ラインを消すエリアの幅
        private var rectangleHeight:Number = stageHeight/3-1;//ラインを消すエリアの高さ
        private var lineArelX:Number = stageWidth/3-49;//ラインがスタートするx位置

        //hours,minutes,secondsの各々の線を消すエリアの定義
        private var hoursArea:Rectangle = new Rectangle(lineArelX,0,rectangleWidth,rectangleHeight);
        private var minutesArea:Rectangle = new Rectangle(lineArelX,stageHeight/3+1,rectangleWidth,rectangleHeight);
        private var secondsArea:Rectangle = new Rectangle(lineArelX,stageHeight/3*2+1,rectangleWidth,rectangleHeight);
       
       //ラインを消す早さ
        private var ct:ColorTransform = new ColorTransform(0.98, 0.98, 0.98);
        private var ctSeconds:ColorTransform = new ColorTransform(0.93, 0.93, 0.93);

        //hours,minutes,secondsの各々の線のポイントを格納する配列の定義
        private var hoursPointArray:Array = [];
        private var minutesPointArray:Array = [];
        private var secondsPointArray:Array = [];

        private var nowSeconds:Number;//現在の秒数を格納しておく為の変数
        private var halfBase:Number = 3;//山の幅
        
        //hours,minutes,secondsの各々の数字を書く為のテキストフィールド
        private var hoursTextField:TextField = new TextField();
        private var minutesTextField:TextField = new TextField();
        private var secondsTextField:TextField = new TextField();
        
        
        public function Main(){
            super(false, 0x000000);
            drawDefaultLine();//画面を区画に分ける線を書く関数
            //hours,minutes,secondsの各々のテキストを表示
            addText("hours",1);
            addText("minutes", 2);
            addText("seconds", 3);

            //hours,minutes,secondsの各々の数字を書く為のテキストフィールドを配置
            addHoursTextField(hoursTextField, 1);
            addHoursTextField(minutesTextField, 2);
            addHoursTextField(secondsTextField, 3);
        }

        public function draw():void{
            var nowTime:Date = new Date();
            var hours:Number = nowTime.hours;
            var minutes:Number = nowTime.minutes;
            var seconds:Number = nowTime.seconds;
            if(nowSeconds != seconds){
                hoursPointArray = createPoints(hours, stageHeight/6);
                minutesPointArray = createPoints(minutes, stageHeight/6*3);
                secondsPointArray = createPoints(seconds, stageHeight/6*5);
                drawLine(hoursPointArray, 0xff0000);
                drawLine(minutesPointArray, 0x00ff00);
                drawLine(secondsPointArray, 0xff00ff);
                nowSeconds = seconds;
            }
            hoursTextField.text = String(hours + 100).substring(1);
            minutesTextField.text = String(minutes + 100).substring(1);
            secondsTextField.text = String(seconds + 100).substring(1);
            bitmapData.colorTransform(hoursArea, ct);
            bitmapData.colorTransform(minutesArea, ct);
            bitmapData.colorTransform(secondsArea, ctSeconds);
        }

        private function createPoints(points:Number, Height:Number):Array{
            var newArray:Array = [];
            if(points != 0){
                for(var i:int = 0; i<points*2 + 1; i++){
                    var xPoint:Number;
                    var yPoint:Number;
                    var newPoint:Point;
                    xPoint = stageWidth/3*2-25 - (halfBase*(points - i));
                    if(i == 0 || i == points*2){
                        yPoint = Height
                    }else if(i%2){
                        //iが奇数のとき
                        yPoint = Height - 50;
                    }else{
                        //iが偶数のとき
                        yPoint = Height + 50;
                    }
                    newPoint = new Point(xPoint, yPoint);
                    newArray.push(newPoint);
                }
            }
            newArray.unshift(new Point(lineArelX,Height));
            newArray.push(new Point(stageWidth, Height));
            return newArray;
        }

        private function drawLine(point:Array, color:int):void{
            for(var i:int = 0; i<point.length-1; i++){
                stroke(color,1);
                line(point[i].x,point[i].y,point[i+1].x,point[i+1].y);
            }
        }
        
        private function drawDefaultLine():void{
            stroke(0xffffff,1);
            line(0,stageHeight/3, stageWidth, stageHeight/3);
            line(0,stageHeight/3*2, stageWidth, stageHeight/3*2);
            line(stageWidth/3-50, 0, stageWidth/3-50, stageHeight);
        }
        
        private function addText(word:String, lineNumber:Number):void{
            var defoultFormat:TextFormat = new TextFormat();
            defoultFormat.color = 0xffffff;
            defoultFormat.size = 30;
            
            var addField:TextField = new TextField();
            addField.defaultTextFormat = defoultFormat;
            addField.autoSize = TextFieldAutoSize.LEFT;
            addField.text = word;
            addField.x = 3;
            addField.y = (stage.stageHeight / 3) * lineNumber - addField.height;
            addChild(addField);
        }
        private function addHoursTextField(textField:TextField, lineNumber:Number):void{
            var defoultFormat:TextFormat = new TextFormat();
            defoultFormat.color = 0xffffff;
            defoultFormat.size = 80;
            textField.defaultTextFormat = defoultFormat;
            textField.x = 3;
            textField.y = (stage.stageHeight / 3) * lineNumber - textField.height;
            addChild(textField);
        }
    }
}